@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * DC Access code in the case of Self Managed Shipping.
 * @property authCode DCAccess Code for the Self Managed shipment.
 */
public data class ListOrderDCAccessCodeResult(
    public val authCode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.ListOrderDCAccessCodeResult):
            ListOrderDCAccessCodeResult = ListOrderDCAccessCodeResult(
            authCode = javaType.authCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
