@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies the mapping between this particular user and the type of access he has on shares on this device.
 * @property accessType Type of access to be allowed on the share for this user.
 * @property shareId The share ID.
 */
public data class ShareAccessRightResponse(
    public val accessType: String,
    public val shareId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.ShareAccessRightResponse):
            ShareAccessRightResponse = ShareAccessRightResponse(
            accessType = javaType.accessType(),
            shareId = javaType.shareId(),
        )
    }
}
