@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Tracking courier information.
 * @property carrierName Name of the carrier used in the delivery.
 * @property serialNumber Serial number of the device being tracked.
 * @property trackingId Tracking ID of the shipment.
 * @property trackingUrl Tracking URL of the shipment.
 */
public data class TrackingInfoResponse(
    public val carrierName: String? = null,
    public val serialNumber: String? = null,
    public val trackingId: String? = null,
    public val trackingUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.TrackingInfoResponse):
            TrackingInfoResponse = TrackingInfoResponse(
            carrierName = javaType.carrierName().map({ args0 -> args0 }).orElse(null),
            serialNumber = javaType.serialNumber().map({ args0 -> args0 }).orElse(null),
            trackingId = javaType.trackingId().map({ args0 -> args0 }).orElse(null),
            trackingUrl = javaType.trackingUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
