@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databoxedge.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The mapping between a particular user and the access type on the SMB share.
 * @property accessType Type of access to be allowed for the user.
 * @property userId User ID (already existing in the device).
 */
public data class UserAccessRightResponse(
    public val accessType: String,
    public val userId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databoxedge.outputs.UserAccessRightResponse):
            UserAccessRightResponse = UserAccessRightResponse(
            accessType = javaType.accessType(),
            userId = javaType.userId(),
        )
    }
}
