@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin

import com.pulumi.azurenative.databricks.VNetPeeringArgs.builder
import com.pulumi.azurenative.databricks.kotlin.inputs.AddressSpaceArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.AddressSpaceArgsBuilder
import com.pulumi.azurenative.databricks.kotlin.inputs.VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetworkArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetworkArgsBuilder
import com.pulumi.azurenative.databricks.kotlin.inputs.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs
import com.pulumi.azurenative.databricks.kotlin.inputs.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Peerings in a VirtualNetwork resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2018-04-01.
 * ## Example Usage
 * ### Create vNet Peering for Workspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vNetPeering = new AzureNative.Databricks.VNetPeering("vNetPeering", new()
 *     {
 *         AllowForwardedTraffic = false,
 *         AllowGatewayTransit = false,
 *         AllowVirtualNetworkAccess = true,
 *         PeeringName = "vNetPeeringTest",
 *         RemoteVirtualNetwork = new AzureNative.Databricks.Inputs.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs
 *         {
 *             Id = "/subscriptions/0140911e-1040-48da-8bc9-b99fb3dd88a6/resourceGroups/subramantest/providers/Microsoft.Network/virtualNetworks/subramanvnet",
 *         },
 *         ResourceGroupName = "rg",
 *         UseRemoteGateways = false,
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewVNetPeering(ctx, "vNetPeering", &databricks.VNetPeeringArgs{
 * 			AllowForwardedTraffic:     pulumi.Bool(false),
 * 			AllowGatewayTransit:       pulumi.Bool(false),
 * 			AllowVirtualNetworkAccess: pulumi.Bool(true),
 * 			PeeringName:               pulumi.String("vNetPeeringTest"),
 * 			RemoteVirtualNetwork: &databricks.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs{
 * 				Id: pulumi.String("/subscriptions/0140911e-1040-48da-8bc9-b99fb3dd88a6/resourceGroups/subramantest/providers/Microsoft.Network/virtualNetworks/subramanvnet"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			UseRemoteGateways: pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.VNetPeering;
 * import com.pulumi.azurenative.databricks.VNetPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vNetPeering = new VNetPeering("vNetPeering", VNetPeeringArgs.builder()
 *             .allowForwardedTraffic(false)
 *             .allowGatewayTransit(false)
 *             .allowVirtualNetworkAccess(true)
 *             .peeringName("vNetPeeringTest")
 *             .remoteVirtualNetwork(Map.of("id", "/subscriptions/0140911e-1040-48da-8bc9-b99fb3dd88a6/resourceGroups/subramantest/providers/Microsoft.Network/virtualNetworks/subramanvnet"))
 *             .resourceGroupName("rg")
 *             .useRemoteGateways(false)
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databricks:VNetPeering vNetPeeringTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Databricks/workspaces/{workspaceName}/virtualNetworkPeerings/{peeringName}
 * ```
 * @property allowForwardedTraffic Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
 * @property allowGatewayTransit If gateway links can be used in remote virtual networking to link to this virtual network.
 * @property allowVirtualNetworkAccess Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
 * @property databricksAddressSpace The reference to the databricks virtual network address space.
 * @property databricksVirtualNetwork  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
 * @property peeringName The name of the workspace vNet peering.
 * @property remoteAddressSpace The reference to the remote virtual network address space.
 * @property remoteVirtualNetwork  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property useRemoteGateways If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
 * @property workspaceName The name of the workspace.
 */
public data class VNetPeeringArgs(
    public val allowForwardedTraffic: Output<Boolean>? = null,
    public val allowGatewayTransit: Output<Boolean>? = null,
    public val allowVirtualNetworkAccess: Output<Boolean>? = null,
    public val databricksAddressSpace: Output<AddressSpaceArgs>? = null,
    public val databricksVirtualNetwork:
    Output<VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetworkArgs>? = null,
    public val peeringName: Output<String>? = null,
    public val remoteAddressSpace: Output<AddressSpaceArgs>? = null,
    public val remoteVirtualNetwork:
    Output<VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val useRemoteGateways: Output<Boolean>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.VNetPeeringArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.VNetPeeringArgs =
        com.pulumi.azurenative.databricks.VNetPeeringArgs.builder()
            .allowForwardedTraffic(allowForwardedTraffic?.applyValue({ args0 -> args0 }))
            .allowGatewayTransit(allowGatewayTransit?.applyValue({ args0 -> args0 }))
            .allowVirtualNetworkAccess(allowVirtualNetworkAccess?.applyValue({ args0 -> args0 }))
            .databricksAddressSpace(
                databricksAddressSpace?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .databricksVirtualNetwork(
                databricksVirtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .peeringName(peeringName?.applyValue({ args0 -> args0 }))
            .remoteAddressSpace(
                remoteAddressSpace?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .remoteVirtualNetwork(
                remoteVirtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .useRemoteGateways(useRemoteGateways?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VNetPeeringArgs].
 */
@PulumiTagMarker
public class VNetPeeringArgsBuilder internal constructor() {
    private var allowForwardedTraffic: Output<Boolean>? = null

    private var allowGatewayTransit: Output<Boolean>? = null

    private var allowVirtualNetworkAccess: Output<Boolean>? = null

    private var databricksAddressSpace: Output<AddressSpaceArgs>? = null

    private var databricksVirtualNetwork:
        Output<VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetworkArgs>? = null

    private var peeringName: Output<String>? = null

    private var remoteAddressSpace: Output<AddressSpaceArgs>? = null

    private var remoteVirtualNetwork:
        Output<VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var useRemoteGateways: Output<Boolean>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
     */
    @JvmName("roqkiswqqnhruhbf")
    public suspend fun allowForwardedTraffic(`value`: Output<Boolean>) {
        this.allowForwardedTraffic = value
    }

    /**
     * @param value If gateway links can be used in remote virtual networking to link to this virtual network.
     */
    @JvmName("tgioyfmikhsfxqfx")
    public suspend fun allowGatewayTransit(`value`: Output<Boolean>) {
        this.allowGatewayTransit = value
    }

    /**
     * @param value Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
     */
    @JvmName("xahjxckdibajwngm")
    public suspend fun allowVirtualNetworkAccess(`value`: Output<Boolean>) {
        this.allowVirtualNetworkAccess = value
    }

    /**
     * @param value The reference to the databricks virtual network address space.
     */
    @JvmName("hruwcagwxomomxmm")
    public suspend fun databricksAddressSpace(`value`: Output<AddressSpaceArgs>) {
        this.databricksAddressSpace = value
    }

    /**
     * @param value  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
     */
    @JvmName("hpecbxihrhrkswvp")
    public suspend
    fun databricksVirtualNetwork(`value`: Output<VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetworkArgs>) {
        this.databricksVirtualNetwork = value
    }

    /**
     * @param value The name of the workspace vNet peering.
     */
    @JvmName("pofbcfgcmsxmibas")
    public suspend fun peeringName(`value`: Output<String>) {
        this.peeringName = value
    }

    /**
     * @param value The reference to the remote virtual network address space.
     */
    @JvmName("osmfmnkdytilbpur")
    public suspend fun remoteAddressSpace(`value`: Output<AddressSpaceArgs>) {
        this.remoteAddressSpace = value
    }

    /**
     * @param value  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
     */
    @JvmName("fnffhnkacxjtijei")
    public suspend
    fun remoteVirtualNetwork(`value`: Output<VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs>) {
        this.remoteVirtualNetwork = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pklkgvjjspcwrcny")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
     */
    @JvmName("rbrukhpswiaintom")
    public suspend fun useRemoteGateways(`value`: Output<Boolean>) {
        this.useRemoteGateways = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("dmeaxppduhtuivtf")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
     */
    @JvmName("mvhudvuasqynsypr")
    public suspend fun allowForwardedTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowForwardedTraffic = mapped
    }

    /**
     * @param value If gateway links can be used in remote virtual networking to link to this virtual network.
     */
    @JvmName("pvlyljiwnqsefcev")
    public suspend fun allowGatewayTransit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowGatewayTransit = mapped
    }

    /**
     * @param value Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
     */
    @JvmName("utwtnxkgctgbymsd")
    public suspend fun allowVirtualNetworkAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowVirtualNetworkAccess = mapped
    }

    /**
     * @param value The reference to the databricks virtual network address space.
     */
    @JvmName("itwoiuqlijdcayul")
    public suspend fun databricksAddressSpace(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databricksAddressSpace = mapped
    }

    /**
     * @param argument The reference to the databricks virtual network address space.
     */
    @JvmName("bmptnucvdxipllhy")
    public suspend fun databricksAddressSpace(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.databricksAddressSpace = mapped
    }

    /**
     * @param value  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
     */
    @JvmName("fxilrijotvdkrwcg")
    public suspend
    fun databricksVirtualNetwork(`value`: VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databricksVirtualNetwork = mapped
    }

    /**
     * @param argument  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
     */
    @JvmName("teybrplubphagsfl")
    public suspend
    fun databricksVirtualNetwork(argument: suspend VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetworkArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetworkArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.databricksVirtualNetwork = mapped
    }

    /**
     * @param value The name of the workspace vNet peering.
     */
    @JvmName("yluyqdomrypprklr")
    public suspend fun peeringName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringName = mapped
    }

    /**
     * @param value The reference to the remote virtual network address space.
     */
    @JvmName("svyhtpruvixldrli")
    public suspend fun remoteAddressSpace(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteAddressSpace = mapped
    }

    /**
     * @param argument The reference to the remote virtual network address space.
     */
    @JvmName("liptlhlxpcuvkqih")
    public suspend fun remoteAddressSpace(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteAddressSpace = mapped
    }

    /**
     * @param value  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
     */
    @JvmName("dbdmpufryxqrbgvv")
    public suspend
    fun remoteVirtualNetwork(`value`: VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteVirtualNetwork = mapped
    }

    /**
     * @param argument  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
     */
    @JvmName("aepcioiramsprghc")
    public suspend
    fun remoteVirtualNetwork(argument: suspend VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgsBuilder.() -> Unit) {
        val toBeMapped =
            VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetworkArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.remoteVirtualNetwork = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("amixiwjwiuysvcgr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
     */
    @JvmName("vkgtforjmmfuvuxc")
    public suspend fun useRemoteGateways(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useRemoteGateways = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("iqcdgvdyxbnttwav")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): VNetPeeringArgs = VNetPeeringArgs(
        allowForwardedTraffic = allowForwardedTraffic,
        allowGatewayTransit = allowGatewayTransit,
        allowVirtualNetworkAccess = allowVirtualNetworkAccess,
        databricksAddressSpace = databricksAddressSpace,
        databricksVirtualNetwork = databricksVirtualNetwork,
        peeringName = peeringName,
        remoteAddressSpace = remoteAddressSpace,
        remoteVirtualNetwork = remoteVirtualNetwork,
        resourceGroupName = resourceGroupName,
        useRemoteGateways = useRemoteGateways,
        workspaceName = workspaceName,
    )
}
