@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin

import com.pulumi.azurenative.databricks.kotlin.outputs.CreatedByResponse
import com.pulumi.azurenative.databricks.kotlin.outputs.ManagedIdentityConfigurationResponse
import com.pulumi.azurenative.databricks.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.databricks.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.databricks.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomParametersResponse
import com.pulumi.azurenative.databricks.kotlin.outputs.WorkspacePropertiesResponseEncryption
import com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceProviderAuthorizationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.databricks.kotlin.outputs.CreatedByResponse.Companion.toKotlin as createdByResponseToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.ManagedIdentityConfigurationResponse.Companion.toKotlin as managedIdentityConfigurationResponseToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceCustomParametersResponse.Companion.toKotlin as workspaceCustomParametersResponseToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.WorkspacePropertiesResponseEncryption.Companion.toKotlin as workspacePropertiesResponseEncryptionToKotlin
import com.pulumi.azurenative.databricks.kotlin.outputs.WorkspaceProviderAuthorizationResponse.Companion.toKotlin as workspaceProviderAuthorizationResponseToKotlin

/**
 * Builder for [Workspace].
 */
@PulumiTagMarker
public class WorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceArgs = WorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceArgsBuilder.() -> Unit) {
        val builder = WorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workspace {
        val builtJavaResource = com.pulumi.azurenative.databricks.Workspace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workspace(builtJavaResource)
    }
}

/**
 * Information about workspace.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2018-04-01.
 * Other available API versions: 2023-09-15-preview, 2024-02-01-preview.
 * ## Example Usage
 * ### Create a workspace which is ready for Customer-Managed Key (CMK) encryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         Parameters = new AzureNative.Databricks.Inputs.WorkspaceCustomParametersArgs
 *         {
 *             PrepareEncryption = new AzureNative.Databricks.Inputs.WorkspaceCustomBooleanParameterArgs
 *             {
 *                 Value = true,
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * 			Location:               pulumi.String("westus"),
 * 			ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			Parameters: databricks.WorkspaceCustomParametersResponse{
 * 				PrepareEncryption: &databricks.WorkspaceCustomBooleanParameterArgs{
 * 					Value: pulumi.Bool(true),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .parameters(Map.of("prepareEncryption", Map.of("value", true)))
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a workspace with Customer-Managed Key (CMK) encryption for Managed Disks
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Encryption = new AzureNative.Databricks.Inputs.WorkspacePropertiesEncryptionArgs
 *         {
 *             Entities = new AzureNative.Databricks.Inputs.EncryptionEntitiesDefinitionArgs
 *             {
 *                 ManagedDisk = new AzureNative.Databricks.Inputs.ManagedDiskEncryptionArgs
 *                 {
 *                     KeySource = "Microsoft.Keyvault",
 *                     KeyVaultProperties = new AzureNative.Databricks.Inputs.ManagedDiskEncryptionKeyVaultPropertiesArgs
 *                     {
 *                         KeyName = "test-cmk-key",
 *                         KeyVaultUri = "https://test-vault-name.vault.azure.net/",
 *                         KeyVersion = "00000000000000000000000000000000",
 *                     },
 *                     RotationToLatestKeyVersionEnabled = true,
 *                 },
 *             },
 *         },
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * Encryption: databricks.WorkspacePropertiesResponseEncryption{
 * Entities: interface{}{
 * ManagedDisk: interface{}{
 * KeySource: pulumi.String("Microsoft.Keyvault"),
 * KeyVaultProperties: &databricks.ManagedDiskEncryptionKeyVaultPropertiesArgs{
 * KeyName: pulumi.String("test-cmk-key"),
 * KeyVaultUri: pulumi.String("https://test-vault-name.vault.azure.net/"),
 * KeyVersion: pulumi.String("00000000000000000000000000000000"),
 * },
 * RotationToLatestKeyVersionEnabled: pulumi.Bool(true),
 * },
 * },
 * },
 * Location: pulumi.String("westus"),
 * ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * ResourceGroupName: pulumi.String("rg"),
 * WorkspaceName: pulumi.String("myWorkspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .encryption(Map.of("entities", Map.of("managedDisk", Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.Keyvault"),
 *                 Map.entry("keyVaultProperties", Map.ofEntries(
 *                     Map.entry("keyName", "test-cmk-key"),
 *                     Map.entry("keyVaultUri", "https://test-vault-name.vault.azure.net/"),
 *                     Map.entry("keyVersion", "00000000000000000000000000000000")
 *                 )),
 *                 Map.entry("rotationToLatestKeyVersionEnabled", true)
 *             ))))
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update workspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * 			Location:               pulumi.String("westus"),
 * 			ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			ResourceGroupName:      pulumi.String("rg"),
 * 			WorkspaceName:          pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update workspace with custom parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         Parameters = new AzureNative.Databricks.Inputs.WorkspaceCustomParametersArgs
 *         {
 *             CustomPrivateSubnetName = new AzureNative.Databricks.Inputs.WorkspaceCustomStringParameterArgs
 *             {
 *                 Value = "myPrivateSubnet",
 *             },
 *             CustomPublicSubnetName = new AzureNative.Databricks.Inputs.WorkspaceCustomStringParameterArgs
 *             {
 *                 Value = "myPublicSubnet",
 *             },
 *             CustomVirtualNetworkId = new AzureNative.Databricks.Inputs.WorkspaceCustomStringParameterArgs
 *             {
 *                 Value = "/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork",
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * 			Location:               pulumi.String("westus"),
 * 			ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * 			Parameters: databricks.WorkspaceCustomParametersResponse{
 * 				CustomPrivateSubnetName: &databricks.WorkspaceCustomStringParameterArgs{
 * 					Value: pulumi.String("myPrivateSubnet"),
 * 				},
 * 				CustomPublicSubnetName: &databricks.WorkspaceCustomStringParameterArgs{
 * 					Value: pulumi.String("myPublicSubnet"),
 * 				},
 * 				CustomVirtualNetworkId: &databricks.WorkspaceCustomStringParameterArgs{
 * 					Value: pulumi.String("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg"),
 * 			WorkspaceName:     pulumi.String("myWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("customPrivateSubnetName", Map.of("value", "myPrivateSubnet")),
 *                 Map.entry("customPublicSubnetName", Map.of("value", "myPublicSubnet")),
 *                 Map.entry("customVirtualNetworkId", Map.of("value", "/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/myNetwork"))
 *             ))
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Enable Customer-Managed Key (CMK) encryption on a workspace which is prepared for encryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         Parameters = new AzureNative.Databricks.Inputs.WorkspaceCustomParametersArgs
 *         {
 *             Encryption = new AzureNative.Databricks.Inputs.WorkspaceEncryptionParameterArgs
 *             {
 *                 Value = new AzureNative.Databricks.Inputs.EncryptionArgs
 *                 {
 *                     KeyName = "myKeyName",
 *                     KeySource = "Microsoft.Keyvault",
 *                     KeyVaultUri = "https://myKeyVault.vault.azure.net/",
 *                     KeyVersion = "00000000000000000000000000000000",
 *                 },
 *             },
 *             PrepareEncryption = new AzureNative.Databricks.Inputs.WorkspaceCustomBooleanParameterArgs
 *             {
 *                 Value = true,
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * Location: pulumi.String("westus"),
 * ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * Parameters: databricks.WorkspaceCustomParametersResponse{
 * Encryption: interface{}{
 * Value: &databricks.EncryptionArgs{
 * KeyName: pulumi.String("myKeyName"),
 * KeySource: pulumi.String("Microsoft.Keyvault"),
 * KeyVaultUri: pulumi.String("https://myKeyVault.vault.azure.net/"),
 * KeyVersion: pulumi.String("00000000000000000000000000000000"),
 * },
 * },
 * PrepareEncryption: &databricks.WorkspaceCustomBooleanParameterArgs{
 * Value: pulumi.Bool(true),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg"),
 * WorkspaceName: pulumi.String("myWorkspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("encryption", Map.of("value", Map.ofEntries(
 *                     Map.entry("keyName", "myKeyName"),
 *                     Map.entry("keySource", "Microsoft.Keyvault"),
 *                     Map.entry("keyVaultUri", "https://myKeyVault.vault.azure.net/"),
 *                     Map.entry("keyVersion", "00000000000000000000000000000000")
 *                 ))),
 *                 Map.entry("prepareEncryption", Map.of("value", true))
 *             ))
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Revert Customer-Managed Key (CMK) encryption to Microsoft Managed Keys encryption on a workspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         Parameters = new AzureNative.Databricks.Inputs.WorkspaceCustomParametersArgs
 *         {
 *             Encryption = new AzureNative.Databricks.Inputs.WorkspaceEncryptionParameterArgs
 *             {
 *                 Value = new AzureNative.Databricks.Inputs.EncryptionArgs
 *                 {
 *                     KeySource = "Default",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg",
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * Location: pulumi.String("westus"),
 * ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * Parameters: databricks.WorkspaceCustomParametersResponse{
 * Encryption: interface{}{
 * Value: &databricks.EncryptionArgs{
 * KeySource: pulumi.String("Default"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("rg"),
 * WorkspaceName: pulumi.String("myWorkspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .parameters(Map.of("encryption", Map.of("value", Map.of("keySource", "Default"))))
 *             .resourceGroupName("rg")
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a workspace with Customer-Managed Key (CMK) encryption for Managed Disks
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.Databricks.Workspace("workspace", new()
 *     {
 *         Encryption = new AzureNative.Databricks.Inputs.WorkspacePropertiesEncryptionArgs
 *         {
 *             Entities = new AzureNative.Databricks.Inputs.EncryptionEntitiesDefinitionArgs
 *             {
 *                 ManagedDisk = new AzureNative.Databricks.Inputs.ManagedDiskEncryptionArgs
 *                 {
 *                     KeySource = "Microsoft.Keyvault",
 *                     KeyVaultProperties = new AzureNative.Databricks.Inputs.ManagedDiskEncryptionKeyVaultPropertiesArgs
 *                     {
 *                         KeyName = "test-cmk-key",
 *                         KeyVaultUri = "https://test-vault-name.vault.azure.net/",
 *                         KeyVersion = "00000000000000000000000000000000",
 *                     },
 *                     RotationToLatestKeyVersionEnabled = true,
 *                 },
 *             },
 *         },
 *         Location = "westus",
 *         ManagedResourceGroupId = "/subscriptions/subid/resourceGroups/myManagedRG",
 *         ResourceGroupName = "rg",
 *         Tags =
 *         {
 *             { "mytag1", "myvalue1" },
 *         },
 *         WorkspaceName = "myWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/databricks/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := databricks.NewWorkspace(ctx, "workspace", &databricks.WorkspaceArgs{
 * Encryption: databricks.WorkspacePropertiesResponseEncryption{
 * Entities: interface{}{
 * ManagedDisk: interface{}{
 * KeySource: pulumi.String("Microsoft.Keyvault"),
 * KeyVaultProperties: &databricks.ManagedDiskEncryptionKeyVaultPropertiesArgs{
 * KeyName: pulumi.String("test-cmk-key"),
 * KeyVaultUri: pulumi.String("https://test-vault-name.vault.azure.net/"),
 * KeyVersion: pulumi.String("00000000000000000000000000000000"),
 * },
 * RotationToLatestKeyVersionEnabled: pulumi.Bool(true),
 * },
 * },
 * },
 * Location: pulumi.String("westus"),
 * ManagedResourceGroupId: pulumi.String("/subscriptions/subid/resourceGroups/myManagedRG"),
 * ResourceGroupName: pulumi.String("rg"),
 * Tags: pulumi.StringMap{
 * "mytag1": pulumi.String("myvalue1"),
 * },
 * WorkspaceName: pulumi.String("myWorkspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.databricks.Workspace;
 * import com.pulumi.azurenative.databricks.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .encryption(Map.of("entities", Map.of("managedDisk", Map.ofEntries(
 *                 Map.entry("keySource", "Microsoft.Keyvault"),
 *                 Map.entry("keyVaultProperties", Map.ofEntries(
 *                     Map.entry("keyName", "test-cmk-key"),
 *                     Map.entry("keyVaultUri", "https://test-vault-name.vault.azure.net/"),
 *                     Map.entry("keyVersion", "00000000000000000000000000000000")
 *                 )),
 *                 Map.entry("rotationToLatestKeyVersionEnabled", true)
 *             ))))
 *             .location("westus")
 *             .managedResourceGroupId("/subscriptions/subid/resourceGroups/myManagedRG")
 *             .resourceGroupName("rg")
 *             .tags(Map.of("mytag1", "myvalue1"))
 *             .workspaceName("myWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:databricks:Workspace myWorkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Databricks/workspaces/{workspaceName}
 * ```
 */
public class Workspace internal constructor(
    override val javaResource: com.pulumi.azurenative.databricks.Workspace,
) : KotlinCustomResource(javaResource, WorkspaceMapper) {
    /**
     * The workspace provider authorizations.
     */
    public val authorizations: Output<List<WorkspaceProviderAuthorizationResponse>>?
        get() = javaResource.authorizations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        workspaceProviderAuthorizationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Indicates the Object ID, PUID and Application ID of entity that created the workspace.
     */
    public val createdBy: Output<CreatedByResponse>?
        get() = javaResource.createdBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    createdByResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the date and time when the workspace is created.
     */
    public val createdDateTime: Output<String>
        get() = javaResource.createdDateTime().applyValue({ args0 -> args0 })

    /**
     * The resource Id of the managed disk encryption set.
     */
    public val diskEncryptionSetId: Output<String>
        get() = javaResource.diskEncryptionSetId().applyValue({ args0 -> args0 })

    /**
     * Encryption properties for databricks workspace
     */
    public val encryption: Output<WorkspacePropertiesResponseEncryption>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workspacePropertiesResponseEncryptionToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The details of Managed Identity of Disk Encryption Set used for Managed Disk Encryption
     */
    public val managedDiskIdentity: Output<ManagedIdentityConfigurationResponse>?
        get() = javaResource.managedDiskIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> managedIdentityConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The managed resource group Id.
     */
    public val managedResourceGroupId: Output<String>
        get() = javaResource.managedResourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The workspace's custom parameters.
     */
    public val parameters: Output<WorkspaceCustomParametersResponse>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workspaceCustomParametersResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Private endpoint connections created on the workspace
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The workspace provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The network access type for accessing workspace. Set value to disabled to access workspace only via private link.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets a value indicating whether data plane (clusters) to control plane communication happen over private endpoint. Supported values are 'AllRules' and 'NoAzureDatabricksRules'. 'NoAzureServiceRules' value is for internal use only.
     */
    public val requiredNsgRules: Output<String>?
        get() = javaResource.requiredNsgRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SKU of the resource.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The details of Managed Identity of Storage Account
     */
    public val storageAccountIdentity: Output<ManagedIdentityConfigurationResponse>?
        get() = javaResource.storageAccountIdentity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> managedIdentityConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The blob URI where the UI definition file is located.
     */
    public val uiDefinitionUri: Output<String>?
        get() = javaResource.uiDefinitionUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates the Object ID, PUID and Application ID of entity that last updated the workspace.
     */
    public val updatedBy: Output<CreatedByResponse>?
        get() = javaResource.updatedBy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    createdByResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The unique identifier of the databricks workspace in databricks control plane.
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })

    /**
     * The workspace URL which is of the format 'adb-{workspaceId}.{random}.azuredatabricks.net'
     */
    public val workspaceUrl: Output<String>
        get() = javaResource.workspaceUrl().applyValue({ args0 -> args0 })
}

public object WorkspaceMapper : ResourceMapper<Workspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.databricks.Workspace::class == javaResource::class

    override fun map(javaResource: Resource): Workspace = Workspace(
        javaResource as
            com.pulumi.azurenative.databricks.Workspace,
    )
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workspace].
 */
public suspend fun workspace(name: String, block: suspend WorkspaceResourceBuilder.() -> Unit):
    Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspace(name: String): Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
