@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets a value indicating whether data plane (clusters) to control plane communication happen over private endpoint. Supported values are 'AllRules' and 'NoAzureDatabricksRules'. 'NoAzureServiceRules' value is for internal use only.
 */
public enum class RequiredNsgRules(
    public val javaValue: com.pulumi.azurenative.databricks.enums.RequiredNsgRules,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.enums.RequiredNsgRules> {
    AllRules(com.pulumi.azurenative.databricks.enums.RequiredNsgRules.AllRules),
    NoAzureDatabricksRules(com.pulumi.azurenative.databricks.enums.RequiredNsgRules.NoAzureDatabricksRules),
    NoAzureServiceRules(com.pulumi.azurenative.databricks.enums.RequiredNsgRules.NoAzureServiceRules),
    ;

    override fun toJava(): com.pulumi.azurenative.databricks.enums.RequiredNsgRules = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.enums.RequiredNsgRules):
            RequiredNsgRules = RequiredNsgRules.values().first { it.javaValue == javaType }
    }
}
