@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.AddressSpaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
 * @property addressPrefixes A list of address blocks reserved for this virtual network in CIDR notation.
 */
public data class AddressSpaceArgs(
    public val addressPrefixes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.AddressSpaceArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.AddressSpaceArgs =
        com.pulumi.azurenative.databricks.inputs.AddressSpaceArgs.builder()
            .addressPrefixes(addressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AddressSpaceArgs].
 */
@PulumiTagMarker
public class AddressSpaceArgsBuilder internal constructor() {
    private var addressPrefixes: Output<List<String>>? = null

    /**
     * @param value A list of address blocks reserved for this virtual network in CIDR notation.
     */
    @JvmName("xsutagucfewqbika")
    public suspend fun addressPrefixes(`value`: Output<List<String>>) {
        this.addressPrefixes = value
    }

    @JvmName("vfrcepohltdqieum")
    public suspend fun addressPrefixes(vararg values: Output<String>) {
        this.addressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values A list of address blocks reserved for this virtual network in CIDR notation.
     */
    @JvmName("pydwsfqlpwoadltt")
    public suspend fun addressPrefixes(values: List<Output<String>>) {
        this.addressPrefixes = Output.all(values)
    }

    /**
     * @param value A list of address blocks reserved for this virtual network in CIDR notation.
     */
    @JvmName("txgiajxssovpjyly")
    public suspend fun addressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param values A list of address blocks reserved for this virtual network in CIDR notation.
     */
    @JvmName("vnyfsrruaqjinuat")
    public suspend fun addressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    internal fun build(): AddressSpaceArgs = AddressSpaceArgs(
        addressPrefixes = addressPrefixes,
    )
}
