@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.inputs

import com.pulumi.azurenative.databricks.inputs.WorkspaceCustomParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Custom Parameters used for Cluster Creation.
 * @property amlWorkspaceId The ID of a Azure Machine Learning workspace to link with Databricks workspace
 * @property customPrivateSubnetName The name of the Private Subnet within the Virtual Network
 * @property customPublicSubnetName The name of a Public Subnet within the Virtual Network
 * @property customVirtualNetworkId The ID of a Virtual Network where this Databricks Cluster should be created
 * @property enableNoPublicIp Should the Public IP be Disabled?
 * @property encryption Contains the encryption details for Customer-Managed Key (CMK) enabled workspace.
 * @property loadBalancerBackendPoolName Name of the outbound Load Balancer Backend Pool for Secure Cluster Connectivity (No Public IP).
 * @property loadBalancerId Resource URI of Outbound Load balancer for Secure Cluster Connectivity (No Public IP) workspace.
 * @property natGatewayName Name of the NAT gateway for Secure Cluster Connectivity (No Public IP) workspace subnets.
 * @property prepareEncryption Prepare the workspace for encryption. Enables the Managed Identity for managed storage account.
 * @property publicIpName Name of the Public IP for No Public IP workspace with managed vNet.
 * @property requireInfrastructureEncryption A boolean indicating whether or not the DBFS root file system will be enabled with secondary layer of encryption with platform managed keys for data at rest.
 * @property storageAccountName Default DBFS storage account name.
 * @property storageAccountSkuName Storage account SKU name, ex: Standard_GRS, Standard_LRS. Refer https://aka.ms/storageskus for valid inputs.
 * @property vnetAddressPrefix Address prefix for Managed virtual network. Default value for this input is 10.139.
 */
public data class WorkspaceCustomParametersArgs(
    public val amlWorkspaceId: Output<WorkspaceCustomStringParameterArgs>? = null,
    public val customPrivateSubnetName: Output<WorkspaceCustomStringParameterArgs>? = null,
    public val customPublicSubnetName: Output<WorkspaceCustomStringParameterArgs>? = null,
    public val customVirtualNetworkId: Output<WorkspaceCustomStringParameterArgs>? = null,
    public val enableNoPublicIp: Output<WorkspaceCustomBooleanParameterArgs>? = null,
    public val encryption: Output<WorkspaceEncryptionParameterArgs>? = null,
    public val loadBalancerBackendPoolName: Output<WorkspaceCustomStringParameterArgs>? = null,
    public val loadBalancerId: Output<WorkspaceCustomStringParameterArgs>? = null,
    public val natGatewayName: Output<WorkspaceCustomStringParameterArgs>? = null,
    public val prepareEncryption: Output<WorkspaceCustomBooleanParameterArgs>? = null,
    public val publicIpName: Output<WorkspaceCustomStringParameterArgs>? = null,
    public val requireInfrastructureEncryption: Output<WorkspaceCustomBooleanParameterArgs>? = null,
    public val storageAccountName: Output<WorkspaceCustomStringParameterArgs>? = null,
    public val storageAccountSkuName: Output<WorkspaceCustomStringParameterArgs>? = null,
    public val vnetAddressPrefix: Output<WorkspaceCustomStringParameterArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.databricks.inputs.WorkspaceCustomParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.databricks.inputs.WorkspaceCustomParametersArgs =
        com.pulumi.azurenative.databricks.inputs.WorkspaceCustomParametersArgs.builder()
            .amlWorkspaceId(amlWorkspaceId?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customPrivateSubnetName(
                customPrivateSubnetName?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customPublicSubnetName(
                customPublicSubnetName?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customVirtualNetworkId(
                customVirtualNetworkId?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .enableNoPublicIp(enableNoPublicIp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loadBalancerBackendPoolName(
                loadBalancerBackendPoolName?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .loadBalancerId(loadBalancerId?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .natGatewayName(natGatewayName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .prepareEncryption(prepareEncryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicIpName(publicIpName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .requireInfrastructureEncryption(
                requireInfrastructureEncryption?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .storageAccountName(
                storageAccountName?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .storageAccountSkuName(
                storageAccountSkuName?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vnetAddressPrefix(
                vnetAddressPrefix?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkspaceCustomParametersArgs].
 */
@PulumiTagMarker
public class WorkspaceCustomParametersArgsBuilder internal constructor() {
    private var amlWorkspaceId: Output<WorkspaceCustomStringParameterArgs>? = null

    private var customPrivateSubnetName: Output<WorkspaceCustomStringParameterArgs>? = null

    private var customPublicSubnetName: Output<WorkspaceCustomStringParameterArgs>? = null

    private var customVirtualNetworkId: Output<WorkspaceCustomStringParameterArgs>? = null

    private var enableNoPublicIp: Output<WorkspaceCustomBooleanParameterArgs>? = null

    private var encryption: Output<WorkspaceEncryptionParameterArgs>? = null

    private var loadBalancerBackendPoolName: Output<WorkspaceCustomStringParameterArgs>? = null

    private var loadBalancerId: Output<WorkspaceCustomStringParameterArgs>? = null

    private var natGatewayName: Output<WorkspaceCustomStringParameterArgs>? = null

    private var prepareEncryption: Output<WorkspaceCustomBooleanParameterArgs>? = null

    private var publicIpName: Output<WorkspaceCustomStringParameterArgs>? = null

    private var requireInfrastructureEncryption: Output<WorkspaceCustomBooleanParameterArgs>? = null

    private var storageAccountName: Output<WorkspaceCustomStringParameterArgs>? = null

    private var storageAccountSkuName: Output<WorkspaceCustomStringParameterArgs>? = null

    private var vnetAddressPrefix: Output<WorkspaceCustomStringParameterArgs>? = null

    /**
     * @param value The ID of a Azure Machine Learning workspace to link with Databricks workspace
     */
    @JvmName("twvgwyyotbibkqpx")
    public suspend fun amlWorkspaceId(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.amlWorkspaceId = value
    }

    /**
     * @param value The name of the Private Subnet within the Virtual Network
     */
    @JvmName("fjwvppplrhsrrlii")
    public suspend fun customPrivateSubnetName(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.customPrivateSubnetName = value
    }

    /**
     * @param value The name of a Public Subnet within the Virtual Network
     */
    @JvmName("ilmpkrwsnauhbidb")
    public suspend fun customPublicSubnetName(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.customPublicSubnetName = value
    }

    /**
     * @param value The ID of a Virtual Network where this Databricks Cluster should be created
     */
    @JvmName("lhcvbarfhkjdwjad")
    public suspend fun customVirtualNetworkId(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.customVirtualNetworkId = value
    }

    /**
     * @param value Should the Public IP be Disabled?
     */
    @JvmName("uotakhrfuxbqauba")
    public suspend fun enableNoPublicIp(`value`: Output<WorkspaceCustomBooleanParameterArgs>) {
        this.enableNoPublicIp = value
    }

    /**
     * @param value Contains the encryption details for Customer-Managed Key (CMK) enabled workspace.
     */
    @JvmName("jpwffhoujbtkxxws")
    public suspend fun encryption(`value`: Output<WorkspaceEncryptionParameterArgs>) {
        this.encryption = value
    }

    /**
     * @param value Name of the outbound Load Balancer Backend Pool for Secure Cluster Connectivity (No Public IP).
     */
    @JvmName("igemuqfuvfcunqlo")
    public suspend
    fun loadBalancerBackendPoolName(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.loadBalancerBackendPoolName = value
    }

    /**
     * @param value Resource URI of Outbound Load balancer for Secure Cluster Connectivity (No Public IP) workspace.
     */
    @JvmName("trokxtmhiukratia")
    public suspend fun loadBalancerId(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.loadBalancerId = value
    }

    /**
     * @param value Name of the NAT gateway for Secure Cluster Connectivity (No Public IP) workspace subnets.
     */
    @JvmName("xfofcijgxjuybnee")
    public suspend fun natGatewayName(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.natGatewayName = value
    }

    /**
     * @param value Prepare the workspace for encryption. Enables the Managed Identity for managed storage account.
     */
    @JvmName("awuclbhkcdscnfix")
    public suspend fun prepareEncryption(`value`: Output<WorkspaceCustomBooleanParameterArgs>) {
        this.prepareEncryption = value
    }

    /**
     * @param value Name of the Public IP for No Public IP workspace with managed vNet.
     */
    @JvmName("glkdhbsndqqpmgyg")
    public suspend fun publicIpName(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.publicIpName = value
    }

    /**
     * @param value A boolean indicating whether or not the DBFS root file system will be enabled with secondary layer of encryption with platform managed keys for data at rest.
     */
    @JvmName("eblrfnuymoccybwl")
    public suspend
    fun requireInfrastructureEncryption(`value`: Output<WorkspaceCustomBooleanParameterArgs>) {
        this.requireInfrastructureEncryption = value
    }

    /**
     * @param value Default DBFS storage account name.
     */
    @JvmName("nsqfqbamrrmtqbbl")
    public suspend fun storageAccountName(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.storageAccountName = value
    }

    /**
     * @param value Storage account SKU name, ex: Standard_GRS, Standard_LRS. Refer https://aka.ms/storageskus for valid inputs.
     */
    @JvmName("qobeggkthfwugiiq")
    public suspend fun storageAccountSkuName(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.storageAccountSkuName = value
    }

    /**
     * @param value Address prefix for Managed virtual network. Default value for this input is 10.139.
     */
    @JvmName("gfougycctpatotpu")
    public suspend fun vnetAddressPrefix(`value`: Output<WorkspaceCustomStringParameterArgs>) {
        this.vnetAddressPrefix = value
    }

    /**
     * @param value The ID of a Azure Machine Learning workspace to link with Databricks workspace
     */
    @JvmName("sljffppfqupnwbik")
    public suspend fun amlWorkspaceId(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amlWorkspaceId = mapped
    }

    /**
     * @param argument The ID of a Azure Machine Learning workspace to link with Databricks workspace
     */
    @JvmName("ghijwdoepgriwlqx")
    public suspend
    fun amlWorkspaceId(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.amlWorkspaceId = mapped
    }

    /**
     * @param value The name of the Private Subnet within the Virtual Network
     */
    @JvmName("ycjxwydviwlombwc")
    public suspend fun customPrivateSubnetName(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPrivateSubnetName = mapped
    }

    /**
     * @param argument The name of the Private Subnet within the Virtual Network
     */
    @JvmName("nafqpuxffbihduvj")
    public suspend
    fun customPrivateSubnetName(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customPrivateSubnetName = mapped
    }

    /**
     * @param value The name of a Public Subnet within the Virtual Network
     */
    @JvmName("fypwajavhauswdnt")
    public suspend fun customPublicSubnetName(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPublicSubnetName = mapped
    }

    /**
     * @param argument The name of a Public Subnet within the Virtual Network
     */
    @JvmName("udylldcgxpxmgjmt")
    public suspend
    fun customPublicSubnetName(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customPublicSubnetName = mapped
    }

    /**
     * @param value The ID of a Virtual Network where this Databricks Cluster should be created
     */
    @JvmName("pmybdcqnrjwoskbl")
    public suspend fun customVirtualNetworkId(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customVirtualNetworkId = mapped
    }

    /**
     * @param argument The ID of a Virtual Network where this Databricks Cluster should be created
     */
    @JvmName("gttyjxowxeqifsuk")
    public suspend
    fun customVirtualNetworkId(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customVirtualNetworkId = mapped
    }

    /**
     * @param value Should the Public IP be Disabled?
     */
    @JvmName("htbqmtxhyorvtbvl")
    public suspend fun enableNoPublicIp(`value`: WorkspaceCustomBooleanParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNoPublicIp = mapped
    }

    /**
     * @param argument Should the Public IP be Disabled?
     */
    @JvmName("njlnmocxroqijgqy")
    public suspend
    fun enableNoPublicIp(argument: suspend WorkspaceCustomBooleanParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomBooleanParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.enableNoPublicIp = mapped
    }

    /**
     * @param value Contains the encryption details for Customer-Managed Key (CMK) enabled workspace.
     */
    @JvmName("mfrlsrfyvyucikpb")
    public suspend fun encryption(`value`: WorkspaceEncryptionParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Contains the encryption details for Customer-Managed Key (CMK) enabled workspace.
     */
    @JvmName("tqyioxclllgdtafj")
    public suspend
    fun encryption(argument: suspend WorkspaceEncryptionParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceEncryptionParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Name of the outbound Load Balancer Backend Pool for Secure Cluster Connectivity (No Public IP).
     */
    @JvmName("kwxmrbaphsvxjulw")
    public suspend fun loadBalancerBackendPoolName(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerBackendPoolName = mapped
    }

    /**
     * @param argument Name of the outbound Load Balancer Backend Pool for Secure Cluster Connectivity (No Public IP).
     */
    @JvmName("xlpwgftcfqjomags")
    public suspend
    fun loadBalancerBackendPoolName(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancerBackendPoolName = mapped
    }

    /**
     * @param value Resource URI of Outbound Load balancer for Secure Cluster Connectivity (No Public IP) workspace.
     */
    @JvmName("cdrmkbipyyawufbg")
    public suspend fun loadBalancerId(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerId = mapped
    }

    /**
     * @param argument Resource URI of Outbound Load balancer for Secure Cluster Connectivity (No Public IP) workspace.
     */
    @JvmName("lwimbxujjdbemhxg")
    public suspend
    fun loadBalancerId(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loadBalancerId = mapped
    }

    /**
     * @param value Name of the NAT gateway for Secure Cluster Connectivity (No Public IP) workspace subnets.
     */
    @JvmName("wwjgsyvcvdpcibtg")
    public suspend fun natGatewayName(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGatewayName = mapped
    }

    /**
     * @param argument Name of the NAT gateway for Secure Cluster Connectivity (No Public IP) workspace subnets.
     */
    @JvmName("serlpcnccfxfhnar")
    public suspend
    fun natGatewayName(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.natGatewayName = mapped
    }

    /**
     * @param value Prepare the workspace for encryption. Enables the Managed Identity for managed storage account.
     */
    @JvmName("bcxtiowmmbaivvww")
    public suspend fun prepareEncryption(`value`: WorkspaceCustomBooleanParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prepareEncryption = mapped
    }

    /**
     * @param argument Prepare the workspace for encryption. Enables the Managed Identity for managed storage account.
     */
    @JvmName("yerimnubdcexrjww")
    public suspend
    fun prepareEncryption(argument: suspend WorkspaceCustomBooleanParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomBooleanParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.prepareEncryption = mapped
    }

    /**
     * @param value Name of the Public IP for No Public IP workspace with managed vNet.
     */
    @JvmName("vjlesnffifxpbydi")
    public suspend fun publicIpName(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpName = mapped
    }

    /**
     * @param argument Name of the Public IP for No Public IP workspace with managed vNet.
     */
    @JvmName("dwyipvcuamvcjonp")
    public suspend
    fun publicIpName(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIpName = mapped
    }

    /**
     * @param value A boolean indicating whether or not the DBFS root file system will be enabled with secondary layer of encryption with platform managed keys for data at rest.
     */
    @JvmName("sqfohgwbguyugbge")
    public suspend
    fun requireInfrastructureEncryption(`value`: WorkspaceCustomBooleanParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireInfrastructureEncryption = mapped
    }

    /**
     * @param argument A boolean indicating whether or not the DBFS root file system will be enabled with secondary layer of encryption with platform managed keys for data at rest.
     */
    @JvmName("hwsboiswgpudseqc")
    public suspend
    fun requireInfrastructureEncryption(argument: suspend WorkspaceCustomBooleanParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomBooleanParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requireInfrastructureEncryption = mapped
    }

    /**
     * @param value Default DBFS storage account name.
     */
    @JvmName("rixnuynarqcjmdxn")
    public suspend fun storageAccountName(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param argument Default DBFS storage account name.
     */
    @JvmName("qsqaqsawetgkplhm")
    public suspend
    fun storageAccountName(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageAccountName = mapped
    }

    /**
     * @param value Storage account SKU name, ex: Standard_GRS, Standard_LRS. Refer https://aka.ms/storageskus for valid inputs.
     */
    @JvmName("ypbfdkbtbgebpkuw")
    public suspend fun storageAccountSkuName(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountSkuName = mapped
    }

    /**
     * @param argument Storage account SKU name, ex: Standard_GRS, Standard_LRS. Refer https://aka.ms/storageskus for valid inputs.
     */
    @JvmName("irmikwdxooxgqhol")
    public suspend
    fun storageAccountSkuName(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageAccountSkuName = mapped
    }

    /**
     * @param value Address prefix for Managed virtual network. Default value for this input is 10.139.
     */
    @JvmName("wdwhdvqqpuqiinyn")
    public suspend fun vnetAddressPrefix(`value`: WorkspaceCustomStringParameterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vnetAddressPrefix = mapped
    }

    /**
     * @param argument Address prefix for Managed virtual network. Default value for this input is 10.139.
     */
    @JvmName("hxryxsxbsamtejvd")
    public suspend
    fun vnetAddressPrefix(argument: suspend WorkspaceCustomStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceCustomStringParameterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vnetAddressPrefix = mapped
    }

    internal fun build(): WorkspaceCustomParametersArgs = WorkspaceCustomParametersArgs(
        amlWorkspaceId = amlWorkspaceId,
        customPrivateSubnetName = customPrivateSubnetName,
        customPublicSubnetName = customPublicSubnetName,
        customVirtualNetworkId = customVirtualNetworkId,
        enableNoPublicIp = enableNoPublicIp,
        encryption = encryption,
        loadBalancerBackendPoolName = loadBalancerBackendPoolName,
        loadBalancerId = loadBalancerId,
        natGatewayName = natGatewayName,
        prepareEncryption = prepareEncryption,
        publicIpName = publicIpName,
        requireInfrastructureEncryption = requireInfrastructureEncryption,
        storageAccountName = storageAccountName,
        storageAccountSkuName = storageAccountSkuName,
        vnetAddressPrefix = vnetAddressPrefix,
    )
}
