@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Provides details of the entity that created/updated the workspace.
 * @property applicationId The application ID of the application that initiated the creation of the workspace. For example, Azure Portal.
 * @property oid The Object ID that created the workspace.
 * @property puid The Personal Object ID corresponding to the object ID above
 */
public data class CreatedByResponse(
    public val applicationId: String,
    public val oid: String,
    public val puid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.CreatedByResponse):
            CreatedByResponse = CreatedByResponse(
            applicationId = javaType.applicationId(),
            oid = javaType.oid(),
            puid = javaType.puid(),
        )
    }
}
