@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Peerings in a VirtualNetwork resource
 * @property allowForwardedTraffic Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
 * @property allowGatewayTransit If gateway links can be used in remote virtual networking to link to this virtual network.
 * @property allowVirtualNetworkAccess Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
 * @property databricksAddressSpace The reference to the databricks virtual network address space.
 * @property databricksVirtualNetwork  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
 * @property id Resource ID.
 * @property name Name of the virtual network peering resource
 * @property peeringState The status of the virtual network peering.
 * @property provisioningState The provisioning state of the virtual network peering resource.
 * @property remoteAddressSpace The reference to the remote virtual network address space.
 * @property remoteVirtualNetwork  The remote virtual network should be in the same region. See here to learn more (https://docs.microsoft.com/en-us/azure/databricks/administration-guide/cloud-configurations/azure/vnet-peering).
 * @property type type of the virtual network peering resource
 * @property useRemoteGateways If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
 */
public data class GetVNetPeeringResult(
    public val allowForwardedTraffic: Boolean? = null,
    public val allowGatewayTransit: Boolean? = null,
    public val allowVirtualNetworkAccess: Boolean? = null,
    public val databricksAddressSpace: AddressSpaceResponse? = null,
    public val databricksVirtualNetwork:
    VirtualNetworkPeeringPropertiesFormatResponseDatabricksVirtualNetwork? = null,
    public val id: String,
    public val name: String,
    public val peeringState: String,
    public val provisioningState: String,
    public val remoteAddressSpace: AddressSpaceResponse? = null,
    public val remoteVirtualNetwork:
    VirtualNetworkPeeringPropertiesFormatResponseRemoteVirtualNetwork,
    public val type: String,
    public val useRemoteGateways: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.GetVNetPeeringResult):
            GetVNetPeeringResult = GetVNetPeeringResult(
            allowForwardedTraffic = javaType.allowForwardedTraffic().map({ args0 -> args0 }).orElse(null),
            allowGatewayTransit = javaType.allowGatewayTransit().map({ args0 -> args0 }).orElse(null),
            allowVirtualNetworkAccess = javaType.allowVirtualNetworkAccess().map({ args0 ->
                args0
            }).orElse(null),
            databricksAddressSpace = javaType.databricksAddressSpace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            databricksVirtualNetwork = javaType.databricksVirtualNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.VirtualNetworkPeeringPropertiesFormatResponseDatabricksVirtualNetwork.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            peeringState = javaType.peeringState(),
            provisioningState = javaType.provisioningState(),
            remoteAddressSpace = javaType.remoteAddressSpace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            remoteVirtualNetwork = javaType.remoteVirtualNetwork().let({ args0 ->
                com.pulumi.azurenative.databricks.kotlin.outputs.VirtualNetworkPeeringPropertiesFormatResponseRemoteVirtualNetwork.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            useRemoteGateways = javaType.useRemoteGateways().map({ args0 -> args0 }).orElse(null),
        )
    }
}
