@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.databricks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a private endpoint connection
 * @property groupIds GroupIds from the private link service resource.
 * @property privateEndpoint Private endpoint
 * @property privateLinkServiceConnectionState Private endpoint connection state
 * @property provisioningState Provisioning state of the private endpoint connection.
 */
public data class PrivateEndpointConnectionPropertiesResponse(
    public val groupIds: List<String>? = null,
    public val privateEndpoint: PrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.databricks.outputs.PrivateEndpointConnectionPropertiesResponse):
            PrivateEndpointConnectionPropertiesResponse = PrivateEndpointConnectionPropertiesResponse(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.databricks.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().let({ args0 ->
                com.pulumi.azurenative.databricks.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
