@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datacatalog.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Azure data catalog SKU.
 */
public enum class SkuType(
    public val javaValue: com.pulumi.azurenative.datacatalog.enums.SkuType,
) : ConvertibleToJava<com.pulumi.azurenative.datacatalog.enums.SkuType> {
    Free(com.pulumi.azurenative.datacatalog.enums.SkuType.Free),
    Standard(com.pulumi.azurenative.datacatalog.enums.SkuType.Standard),
    ;

    override fun toJava(): com.pulumi.azurenative.datacatalog.enums.SkuType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datacatalog.enums.SkuType): SkuType =
            SkuType.values().first { it.javaValue == javaType }
    }
}
