@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datacatalog.kotlin.inputs

import com.pulumi.azurenative.datacatalog.inputs.GetADCCatalogPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName The name of the data catalog in the specified subscription and resource group.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetADCCatalogPlainArgs(
    public val catalogName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datacatalog.inputs.GetADCCatalogPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datacatalog.inputs.GetADCCatalogPlainArgs =
        com.pulumi.azurenative.datacatalog.inputs.GetADCCatalogPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetADCCatalogPlainArgs].
 */
@PulumiTagMarker
public class GetADCCatalogPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the data catalog in the specified subscription and resource group.
     */
    @JvmName("ljcbtsnowvuqeynl")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("wxmfgdqglmnrdqsp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetADCCatalogPlainArgs = GetADCCatalogPlainArgs(
        catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
