@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin

import com.pulumi.azurenative.datadog.DatadogFunctions.getMonitorDefaultKeyPlain
import com.pulumi.azurenative.datadog.DatadogFunctions.getMonitorPlain
import com.pulumi.azurenative.datadog.DatadogFunctions.getMonitoredSubscriptionPlain
import com.pulumi.azurenative.datadog.DatadogFunctions.listMonitorApiKeysPlain
import com.pulumi.azurenative.datadog.DatadogFunctions.listMonitorHostsPlain
import com.pulumi.azurenative.datadog.DatadogFunctions.listMonitorLinkedResourcesPlain
import com.pulumi.azurenative.datadog.DatadogFunctions.listMonitorMonitoredResourcesPlain
import com.pulumi.azurenative.datadog.kotlin.inputs.GetMonitorDefaultKeyPlainArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.GetMonitorDefaultKeyPlainArgsBuilder
import com.pulumi.azurenative.datadog.kotlin.inputs.GetMonitorPlainArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.GetMonitorPlainArgsBuilder
import com.pulumi.azurenative.datadog.kotlin.inputs.GetMonitoredSubscriptionPlainArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.GetMonitoredSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.datadog.kotlin.inputs.ListMonitorApiKeysPlainArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.ListMonitorApiKeysPlainArgsBuilder
import com.pulumi.azurenative.datadog.kotlin.inputs.ListMonitorHostsPlainArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.ListMonitorHostsPlainArgsBuilder
import com.pulumi.azurenative.datadog.kotlin.inputs.ListMonitorLinkedResourcesPlainArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.ListMonitorLinkedResourcesPlainArgsBuilder
import com.pulumi.azurenative.datadog.kotlin.inputs.ListMonitorMonitoredResourcesPlainArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.ListMonitorMonitoredResourcesPlainArgsBuilder
import com.pulumi.azurenative.datadog.kotlin.outputs.GetMonitorDefaultKeyResult
import com.pulumi.azurenative.datadog.kotlin.outputs.GetMonitorResult
import com.pulumi.azurenative.datadog.kotlin.outputs.GetMonitoredSubscriptionResult
import com.pulumi.azurenative.datadog.kotlin.outputs.ListMonitorApiKeysResult
import com.pulumi.azurenative.datadog.kotlin.outputs.ListMonitorHostsResult
import com.pulumi.azurenative.datadog.kotlin.outputs.ListMonitorLinkedResourcesResult
import com.pulumi.azurenative.datadog.kotlin.outputs.ListMonitorMonitoredResourcesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datadog.kotlin.outputs.GetMonitorDefaultKeyResult.Companion.toKotlin as getMonitorDefaultKeyResultToKotlin
import com.pulumi.azurenative.datadog.kotlin.outputs.GetMonitorResult.Companion.toKotlin as getMonitorResultToKotlin
import com.pulumi.azurenative.datadog.kotlin.outputs.GetMonitoredSubscriptionResult.Companion.toKotlin as getMonitoredSubscriptionResultToKotlin
import com.pulumi.azurenative.datadog.kotlin.outputs.ListMonitorApiKeysResult.Companion.toKotlin as listMonitorApiKeysResultToKotlin
import com.pulumi.azurenative.datadog.kotlin.outputs.ListMonitorHostsResult.Companion.toKotlin as listMonitorHostsResultToKotlin
import com.pulumi.azurenative.datadog.kotlin.outputs.ListMonitorLinkedResourcesResult.Companion.toKotlin as listMonitorLinkedResourcesResultToKotlin
import com.pulumi.azurenative.datadog.kotlin.outputs.ListMonitorMonitoredResourcesResult.Companion.toKotlin as listMonitorMonitoredResourcesResultToKotlin

public object DatadogFunctions {
    /**
     *
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2022-08-01, 2023-01-01.
     * @param argument null
     * @return null
     */
    public suspend fun getMonitor(argument: GetMonitorPlainArgs): GetMonitorResult =
        getMonitorResultToKotlin(getMonitorPlain(argument.toJava()).await())

    /**
     * @see [getMonitor].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getMonitor(monitorName: String, resourceGroupName: String): GetMonitorResult {
        val argument = GetMonitorPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getMonitorResultToKotlin(getMonitorPlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitor].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datadog&#46;kotlin&#46;inputs&#46;GetMonitorPlainArgs].
     * @return null
     */
    public suspend fun getMonitor(argument: suspend GetMonitorPlainArgsBuilder.() -> Unit):
        GetMonitorResult {
        val builder = GetMonitorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitorResultToKotlin(getMonitorPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2022-08-01, 2023-01-01.
     * @param argument null
     * @return null
     */
    public suspend fun getMonitorDefaultKey(argument: GetMonitorDefaultKeyPlainArgs):
        GetMonitorDefaultKeyResult =
        getMonitorDefaultKeyResultToKotlin(getMonitorDefaultKeyPlain(argument.toJava()).await())

    /**
     * @see [getMonitorDefaultKey].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getMonitorDefaultKey(monitorName: String, resourceGroupName: String):
        GetMonitorDefaultKeyResult {
        val argument = GetMonitorDefaultKeyPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getMonitorDefaultKeyResultToKotlin(getMonitorDefaultKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitorDefaultKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datadog&#46;kotlin&#46;inputs&#46;GetMonitorDefaultKeyPlainArgs].
     * @return null
     */
    public suspend
    fun getMonitorDefaultKey(argument: suspend GetMonitorDefaultKeyPlainArgsBuilder.() -> Unit):
        GetMonitorDefaultKeyResult {
        val builder = GetMonitorDefaultKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitorDefaultKeyResultToKotlin(getMonitorDefaultKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * The request to update subscriptions needed to be monitored by the Datadog monitor resource.
     * Azure REST API version: 2023-01-01.
     * @param argument null
     * @return The request to update subscriptions needed to be monitored by the Datadog monitor resource.
     */
    public suspend fun getMonitoredSubscription(argument: GetMonitoredSubscriptionPlainArgs):
        GetMonitoredSubscriptionResult =
        getMonitoredSubscriptionResultToKotlin(getMonitoredSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getMonitoredSubscription].
     * @param configurationName The configuration name. Only 'default' value is supported.
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The request to update subscriptions needed to be monitored by the Datadog monitor resource.
     */
    public suspend fun getMonitoredSubscription(
        configurationName: String,
        monitorName: String,
        resourceGroupName: String,
    ): GetMonitoredSubscriptionResult {
        val argument = GetMonitoredSubscriptionPlainArgs(
            configurationName = configurationName,
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return getMonitoredSubscriptionResultToKotlin(getMonitoredSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMonitoredSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datadog&#46;kotlin&#46;inputs&#46;GetMonitoredSubscriptionPlainArgs].
     * @return The request to update subscriptions needed to be monitored by the Datadog monitor resource.
     */
    public suspend
    fun getMonitoredSubscription(argument: suspend GetMonitoredSubscriptionPlainArgsBuilder.() -> Unit):
        GetMonitoredSubscriptionResult {
        val builder = GetMonitoredSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMonitoredSubscriptionResultToKotlin(getMonitoredSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Response of a list operation.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2022-08-01, 2023-01-01.
     * @param argument null
     * @return Response of a list operation.
     */
    public suspend fun listMonitorApiKeys(argument: ListMonitorApiKeysPlainArgs):
        ListMonitorApiKeysResult =
        listMonitorApiKeysResultToKotlin(listMonitorApiKeysPlain(argument.toJava()).await())

    /**
     * @see [listMonitorApiKeys].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response of a list operation.
     */
    public suspend fun listMonitorApiKeys(monitorName: String, resourceGroupName: String):
        ListMonitorApiKeysResult {
        val argument = ListMonitorApiKeysPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listMonitorApiKeysResultToKotlin(listMonitorApiKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listMonitorApiKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datadog&#46;kotlin&#46;inputs&#46;ListMonitorApiKeysPlainArgs].
     * @return Response of a list operation.
     */
    public suspend
    fun listMonitorApiKeys(argument: suspend ListMonitorApiKeysPlainArgsBuilder.() -> Unit):
        ListMonitorApiKeysResult {
        val builder = ListMonitorApiKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMonitorApiKeysResultToKotlin(listMonitorApiKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Response of a list operation.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2022-08-01, 2023-01-01.
     * @param argument null
     * @return Response of a list operation.
     */
    public suspend fun listMonitorHosts(argument: ListMonitorHostsPlainArgs): ListMonitorHostsResult =
        listMonitorHostsResultToKotlin(listMonitorHostsPlain(argument.toJava()).await())

    /**
     * @see [listMonitorHosts].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response of a list operation.
     */
    public suspend fun listMonitorHosts(monitorName: String, resourceGroupName: String):
        ListMonitorHostsResult {
        val argument = ListMonitorHostsPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listMonitorHostsResultToKotlin(listMonitorHostsPlain(argument.toJava()).await())
    }

    /**
     * @see [listMonitorHosts].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datadog&#46;kotlin&#46;inputs&#46;ListMonitorHostsPlainArgs].
     * @return Response of a list operation.
     */
    public suspend
    fun listMonitorHosts(argument: suspend ListMonitorHostsPlainArgsBuilder.() -> Unit):
        ListMonitorHostsResult {
        val builder = ListMonitorHostsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMonitorHostsResultToKotlin(listMonitorHostsPlain(builtArgument.toJava()).await())
    }

    /**
     * Response of a list operation.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2022-08-01, 2023-01-01.
     * @param argument null
     * @return Response of a list operation.
     */
    public suspend fun listMonitorLinkedResources(argument: ListMonitorLinkedResourcesPlainArgs):
        ListMonitorLinkedResourcesResult =
        listMonitorLinkedResourcesResultToKotlin(listMonitorLinkedResourcesPlain(argument.toJava()).await())

    /**
     * @see [listMonitorLinkedResources].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response of a list operation.
     */
    public suspend fun listMonitorLinkedResources(monitorName: String, resourceGroupName: String):
        ListMonitorLinkedResourcesResult {
        val argument = ListMonitorLinkedResourcesPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listMonitorLinkedResourcesResultToKotlin(listMonitorLinkedResourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [listMonitorLinkedResources].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datadog&#46;kotlin&#46;inputs&#46;ListMonitorLinkedResourcesPlainArgs].
     * @return Response of a list operation.
     */
    public suspend
    fun listMonitorLinkedResources(argument: suspend ListMonitorLinkedResourcesPlainArgsBuilder.() -> Unit):
        ListMonitorLinkedResourcesResult {
        val builder = ListMonitorLinkedResourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMonitorLinkedResourcesResultToKotlin(listMonitorLinkedResourcesPlain(builtArgument.toJava()).await())
    }

    /**
     * Response of a list operation.
     * Azure REST API version: 2022-06-01.
     * Other available API versions: 2022-08-01, 2023-01-01.
     * @param argument null
     * @return Response of a list operation.
     */
    public suspend
    fun listMonitorMonitoredResources(argument: ListMonitorMonitoredResourcesPlainArgs):
        ListMonitorMonitoredResourcesResult =
        listMonitorMonitoredResourcesResultToKotlin(listMonitorMonitoredResourcesPlain(argument.toJava()).await())

    /**
     * @see [listMonitorMonitoredResources].
     * @param monitorName Monitor resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response of a list operation.
     */
    public suspend fun listMonitorMonitoredResources(monitorName: String, resourceGroupName: String):
        ListMonitorMonitoredResourcesResult {
        val argument = ListMonitorMonitoredResourcesPlainArgs(
            monitorName = monitorName,
            resourceGroupName = resourceGroupName,
        )
        return listMonitorMonitoredResourcesResultToKotlin(listMonitorMonitoredResourcesPlain(argument.toJava()).await())
    }

    /**
     * @see [listMonitorMonitoredResources].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datadog&#46;kotlin&#46;inputs&#46;ListMonitorMonitoredResourcesPlainArgs].
     * @return Response of a list operation.
     */
    public suspend
    fun listMonitorMonitoredResources(argument: suspend ListMonitorMonitoredResourcesPlainArgsBuilder.() -> Unit):
        ListMonitorMonitoredResourcesResult {
        val builder = ListMonitorMonitoredResourcesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listMonitorMonitoredResourcesResultToKotlin(listMonitorMonitoredResourcesPlain(builtArgument.toJava()).await())
    }
}
