@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin

import com.pulumi.azurenative.datadog.MonitoredSubscriptionArgs.builder
import com.pulumi.azurenative.datadog.kotlin.inputs.SubscriptionListArgs
import com.pulumi.azurenative.datadog.kotlin.inputs.SubscriptionListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The request to update subscriptions needed to be monitored by the Datadog monitor resource.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### Monitors_AddMonitoredSubscriptions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var monitoredSubscription = new AzureNative.Datadog.MonitoredSubscription("monitoredSubscription", new()
 *     {
 *         ConfigurationName = "default",
 *         MonitorName = "myMonitor",
 *         Properties = new AzureNative.Datadog.Inputs.SubscriptionListArgs
 *         {
 *             MonitoredSubscriptionList = new[]
 *             {
 *                 new AzureNative.Datadog.Inputs.MonitoredSubscriptionArgs
 *                 {
 *                     Status = "Active",
 *                     SubscriptionId = "/subscriptions/00000000-0000-0000-0000-000000000000",
 *                     TagRules = new AzureNative.Datadog.Inputs.MonitoringTagRulesPropertiesArgs
 *                     {
 *                         Automuting = true,
 *                         LogRules = new AzureNative.Datadog.Inputs.LogRulesArgs
 *                         {
 *                             FilteringTags = new[]
 *                             {
 *                                 new AzureNative.Datadog.Inputs.FilteringTagArgs
 *                                 {
 *                                     Action = "Include",
 *                                     Name = "Environment",
 *                                     Value = "Prod",
 *                                 },
 *                                 new AzureNative.Datadog.Inputs.FilteringTagArgs
 *                                 {
 *                                     Action = "Exclude",
 *                                     Name = "Environment",
 *                                     Value = "Dev",
 *                                 },
 *                             },
 *                             SendAadLogs = false,
 *                             SendResourceLogs = true,
 *                             SendSubscriptionLogs = true,
 *                         },
 *                         MetricRules = new AzureNative.Datadog.Inputs.MetricRulesArgs
 *                         {
 *                             FilteringTags = new[] {},
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.Datadog.Inputs.MonitoredSubscriptionArgs
 *                 {
 *                     Status = "Failed",
 *                     SubscriptionId = "/subscriptions/00000000-0000-0000-0000-000000000001",
 *                     TagRules = new AzureNative.Datadog.Inputs.MonitoringTagRulesPropertiesArgs
 *                     {
 *                         Automuting = true,
 *                         LogRules = new AzureNative.Datadog.Inputs.LogRulesArgs
 *                         {
 *                             FilteringTags = new[]
 *                             {
 *                                 new AzureNative.Datadog.Inputs.FilteringTagArgs
 *                                 {
 *                                     Action = "Include",
 *                                     Name = "Environment",
 *                                     Value = "Prod",
 *                                 },
 *                                 new AzureNative.Datadog.Inputs.FilteringTagArgs
 *                                 {
 *                                     Action = "Exclude",
 *                                     Name = "Environment",
 *                                     Value = "Dev",
 *                                 },
 *                             },
 *                             SendAadLogs = false,
 *                             SendResourceLogs = true,
 *                             SendSubscriptionLogs = true,
 *                         },
 *                         MetricRules = new AzureNative.Datadog.Inputs.MetricRulesArgs
 *                         {
 *                             FilteringTags = new[] {},
 *                         },
 *                     },
 *                 },
 *             },
 *             Operation = "AddBegin",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datadog/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datadog.NewMonitoredSubscription(ctx, "monitoredSubscription", &datadog.MonitoredSubscriptionArgs{
 * ConfigurationName: pulumi.String("default"),
 * MonitorName: pulumi.String("myMonitor"),
 * Properties: datadog.SubscriptionListResponse{
 * MonitoredSubscriptionList: datadog.MonitoredSubscriptionTypeArray{
 * interface{}{
 * Status: pulumi.String("Active"),
 * SubscriptionId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000"),
 * TagRules: interface{}{
 * Automuting: pulumi.Bool(true),
 * LogRules: interface{}{
 * FilteringTags: datadog.FilteringTagArray{
 * &datadog.FilteringTagArgs{
 * Action: pulumi.String("Include"),
 * Name: pulumi.String("Environment"),
 * Value: pulumi.String("Prod"),
 * },
 * &datadog.FilteringTagArgs{
 * Action: pulumi.String("Exclude"),
 * Name: pulumi.String("Environment"),
 * Value: pulumi.String("Dev"),
 * },
 * },
 * SendAadLogs: pulumi.Bool(false),
 * SendResourceLogs: pulumi.Bool(true),
 * SendSubscriptionLogs: pulumi.Bool(true),
 * },
 * MetricRules: interface{}{
 * FilteringTags: datadog.FilteringTagArray{
 * },
 * },
 * },
 * },
 * interface{}{
 * Status: pulumi.String("Failed"),
 * SubscriptionId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000001"),
 * TagRules: interface{}{
 * Automuting: pulumi.Bool(true),
 * LogRules: interface{}{
 * FilteringTags: datadog.FilteringTagArray{
 * &datadog.FilteringTagArgs{
 * Action: pulumi.String("Include"),
 * Name: pulumi.String("Environment"),
 * Value: pulumi.String("Prod"),
 * },
 * &datadog.FilteringTagArgs{
 * Action: pulumi.String("Exclude"),
 * Name: pulumi.String("Environment"),
 * Value: pulumi.String("Dev"),
 * },
 * },
 * SendAadLogs: pulumi.Bool(false),
 * SendResourceLogs: pulumi.Bool(true),
 * SendSubscriptionLogs: pulumi.Bool(true),
 * },
 * MetricRules: interface{}{
 * FilteringTags: datadog.FilteringTagArray{
 * },
 * },
 * },
 * },
 * },
 * Operation: pulumi.String("AddBegin"),
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datadog.MonitoredSubscription;
 * import com.pulumi.azurenative.datadog.MonitoredSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var monitoredSubscription = new MonitoredSubscription("monitoredSubscription", MonitoredSubscriptionArgs.builder()
 *             .configurationName("default")
 *             .monitorName("myMonitor")
 *             .properties(Map.ofEntries(
 *                 Map.entry("monitoredSubscriptionList",
 *                     Map.ofEntries(
 *                         Map.entry("status", "Active"),
 *                         Map.entry("subscriptionId", "/subscriptions/00000000-0000-0000-0000-000000000000"),
 *                         Map.entry("tagRules", Map.ofEntries(
 *                             Map.entry("automuting", true),
 *                             Map.entry("logRules", Map.ofEntries(
 *                                 Map.entry("filteringTags",
 *                                     Map.ofEntries(
 *                                         Map.entry("action", "Include"),
 *                                         Map.entry("name", "Environment"),
 *                                         Map.entry("value", "Prod")
 *                                     ),
 *                                     Map.ofEntries(
 *                                         Map.entry("action", "Exclude"),
 *                                         Map.entry("name", "Environment"),
 *                                         Map.entry("value", "Dev")
 *                                     )),
 *                                 Map.entry("sendAadLogs", false),
 *                                 Map.entry("sendResourceLogs", true),
 *                                 Map.entry("sendSubscriptionLogs", true)
 *                             )),
 *                             Map.entry("metricRules", Map.of("filteringTags", ))
 *                         ))
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("status", "Failed"),
 *                         Map.entry("subscriptionId", "/subscriptions/00000000-0000-0000-0000-000000000001"),
 *                         Map.entry("tagRules", Map.ofEntries(
 *                             Map.entry("automuting", true),
 *                             Map.entry("logRules", Map.ofEntries(
 *                                 Map.entry("filteringTags",
 *                                     Map.ofEntries(
 *                                         Map.entry("action", "Include"),
 *                                         Map.entry("name", "Environment"),
 *                                         Map.entry("value", "Prod")
 *                                     ),
 *                                     Map.ofEntries(
 *                                         Map.entry("action", "Exclude"),
 *                                         Map.entry("name", "Environment"),
 *                                         Map.entry("value", "Dev")
 *                                     )),
 *                                 Map.entry("sendAadLogs", false),
 *                                 Map.entry("sendResourceLogs", true),
 *                                 Map.entry("sendSubscriptionLogs", true)
 *                             )),
 *                             Map.entry("metricRules", Map.of("filteringTags", ))
 *                         ))
 *                     )),
 *                 Map.entry("operation", "AddBegin")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datadog:MonitoredSubscription default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Datadog/monitors/{monitorName}/monitoredSubscriptions/{configurationName}
 * ```
 * @property configurationName The configuration name. Only 'default' value is supported.
 * @property monitorName Monitor resource name
 * @property properties The request to update subscriptions needed to be monitored by the Datadog monitor resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class MonitoredSubscriptionArgs(
    public val configurationName: Output<String>? = null,
    public val monitorName: Output<String>? = null,
    public val properties: Output<SubscriptionListArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.MonitoredSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.MonitoredSubscriptionArgs =
        com.pulumi.azurenative.datadog.MonitoredSubscriptionArgs.builder()
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitoredSubscriptionArgs].
 */
@PulumiTagMarker
public class MonitoredSubscriptionArgsBuilder internal constructor() {
    private var configurationName: Output<String>? = null

    private var monitorName: Output<String>? = null

    private var properties: Output<SubscriptionListArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The configuration name. Only 'default' value is supported.
     */
    @JvmName("dnlyjvpyyokuaujb")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("mfpaemtudmgdiexh")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value The request to update subscriptions needed to be monitored by the Datadog monitor resource.
     */
    @JvmName("gyfouerntvxewvgl")
    public suspend fun properties(`value`: Output<SubscriptionListArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bkrlogfedohptxrq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The configuration name. Only 'default' value is supported.
     */
    @JvmName("qaysdhsgoedqtciw")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("cncciouhrmhjjbqf")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value The request to update subscriptions needed to be monitored by the Datadog monitor resource.
     */
    @JvmName("dphfnewtgxjjpkqn")
    public suspend fun properties(`value`: SubscriptionListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The request to update subscriptions needed to be monitored by the Datadog monitor resource.
     */
    @JvmName("tpohftgwbewkplja")
    public suspend fun properties(argument: suspend SubscriptionListArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriptionListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lkkqpfkyjjihrklb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): MonitoredSubscriptionArgs = MonitoredSubscriptionArgs(
        configurationName = configurationName,
        monitorName = monitorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
