@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.ListMonitorHostsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListMonitorHostsPlainArgs(
    public val monitorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.ListMonitorHostsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.ListMonitorHostsPlainArgs =
        com.pulumi.azurenative.datadog.inputs.ListMonitorHostsPlainArgs.builder()
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListMonitorHostsPlainArgs].
 */
@PulumiTagMarker
public class ListMonitorHostsPlainArgsBuilder internal constructor() {
    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Monitor resource name
     */
    @JvmName("ycpkawbdoohuxghf")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ijarfpqpnccuwdqs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListMonitorHostsPlainArgs = ListMonitorHostsPlainArgs(
        monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
