@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.ListMonitorMonitoredResourcesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListMonitorMonitoredResourcesPlainArgs(
    public val monitorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.ListMonitorMonitoredResourcesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datadog.inputs.ListMonitorMonitoredResourcesPlainArgs =
        com.pulumi.azurenative.datadog.inputs.ListMonitorMonitoredResourcesPlainArgs.builder()
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListMonitorMonitoredResourcesPlainArgs].
 */
@PulumiTagMarker
public class ListMonitorMonitoredResourcesPlainArgsBuilder internal constructor() {
    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Monitor resource name
     */
    @JvmName("dujvhticbgmogpuy")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ffeuewplclfuthrc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListMonitorMonitoredResourcesPlainArgs =
        ListMonitorMonitoredResourcesPlainArgs(
            monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
