@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.kotlin.outputs.ChangeDataCaptureResponseFolder
import com.pulumi.azurenative.datafactory.kotlin.outputs.MapperPolicyResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.MapperSourceConnectionsInfoResponse
import com.pulumi.azurenative.datafactory.kotlin.outputs.MapperTargetConnectionsInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.datafactory.kotlin.outputs.ChangeDataCaptureResponseFolder.Companion.toKotlin as changeDataCaptureResponseFolderToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.MapperPolicyResponse.Companion.toKotlin as mapperPolicyResponseToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.MapperSourceConnectionsInfoResponse.Companion.toKotlin as mapperSourceConnectionsInfoResponseToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.MapperTargetConnectionsInfoResponse.Companion.toKotlin as mapperTargetConnectionsInfoResponseToKotlin

/**
 * Builder for [ChangeDataCapture].
 */
@PulumiTagMarker
public class ChangeDataCaptureResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ChangeDataCaptureArgs = ChangeDataCaptureArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ChangeDataCaptureArgsBuilder.() -> Unit) {
        val builder = ChangeDataCaptureArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ChangeDataCapture {
        val builtJavaResource =
            com.pulumi.azurenative.datafactory.ChangeDataCapture(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ChangeDataCapture(builtJavaResource)
    }
}

/**
 * Change data capture resource type.
 * Azure REST API version: 2018-06-01.
 * ## Example Usage
 * ### ChangeDataCapture_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var changeDataCapture = new AzureNative.DataFactory.ChangeDataCapture("changeDataCapture", new()
 *     {
 *         AllowVNetOverride = false,
 *         ChangeDataCaptureName = "exampleChangeDataCapture",
 *         Description = "Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database with automapped and non-automapped mappings.",
 *         FactoryName = "exampleFactoryName",
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewChangeDataCapture(ctx, "changeDataCapture", &datafactory.ChangeDataCaptureArgs{
 * 			AllowVNetOverride:     pulumi.Bool(false),
 * 			ChangeDataCaptureName: pulumi.String("exampleChangeDataCapture"),
 * 			Description:           pulumi.String("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database with automapped and non-automapped mappings."),
 * 			FactoryName:           pulumi.String("exampleFactoryName"),
 * 			ResourceGroupName:     pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.ChangeDataCapture;
 * import com.pulumi.azurenative.datafactory.ChangeDataCaptureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var changeDataCapture = new ChangeDataCapture("changeDataCapture", ChangeDataCaptureArgs.builder()
 *             .allowVNetOverride(false)
 *             .changeDataCaptureName("exampleChangeDataCapture")
 *             .description("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database with automapped and non-automapped mappings.")
 *             .factoryName("exampleFactoryName")
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### ChangeDataCapture_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var changeDataCapture = new AzureNative.DataFactory.ChangeDataCapture("changeDataCapture", new()
 *     {
 *         AllowVNetOverride = false,
 *         ChangeDataCaptureName = "exampleChangeDataCapture",
 *         Description = "Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database. Updating table mappings.",
 *         FactoryName = "exampleFactoryName",
 *         ResourceGroupName = "exampleResourceGroup",
 *         Status = "Stopped",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewChangeDataCapture(ctx, "changeDataCapture", &datafactory.ChangeDataCaptureArgs{
 * 			AllowVNetOverride:     pulumi.Bool(false),
 * 			ChangeDataCaptureName: pulumi.String("exampleChangeDataCapture"),
 * 			Description:           pulumi.String("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database. Updating table mappings."),
 * 			FactoryName:           pulumi.String("exampleFactoryName"),
 * 			ResourceGroupName:     pulumi.String("exampleResourceGroup"),
 * 			Status:                pulumi.String("Stopped"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.ChangeDataCapture;
 * import com.pulumi.azurenative.datafactory.ChangeDataCaptureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var changeDataCapture = new ChangeDataCapture("changeDataCapture", ChangeDataCaptureArgs.builder()
 *             .allowVNetOverride(false)
 *             .changeDataCaptureName("exampleChangeDataCapture")
 *             .description("Sample demo change data capture to transfer data from delimited (csv) to Azure SQL Database. Updating table mappings.")
 *             .factoryName("exampleFactoryName")
 *             .resourceGroupName("exampleResourceGroup")
 *             .status("Stopped")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:ChangeDataCapture exampleChangeDataCapture /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/adfcdcs/{changeDataCaptureName}
 * ```
 */
public class ChangeDataCapture internal constructor(
    override val javaResource: com.pulumi.azurenative.datafactory.ChangeDataCapture,
) : KotlinCustomResource(javaResource, ChangeDataCaptureMapper) {
    /**
     * A boolean to determine if the vnet configuration needs to be overwritten.
     */
    public val allowVNetOverride: Output<Boolean>?
        get() = javaResource.allowVNetOverride().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the change data capture.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Etag identifies change in the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The folder that this CDC is in. If not specified, CDC will appear at the root level.
     */
    public val folder: Output<ChangeDataCaptureResponseFolder>?
        get() = javaResource.folder().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    changeDataCaptureResponseFolderToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * CDC policy
     */
    public val policy: Output<MapperPolicyResponse>
        get() = javaResource.policy().applyValue({ args0 ->
            args0.let({ args0 ->
                mapperPolicyResponseToKotlin(args0)
            })
        })

    /**
     * List of sources connections that can be used as sources in the CDC.
     */
    public val sourceConnectionsInfo: Output<List<MapperSourceConnectionsInfoResponse>>
        get() = javaResource.sourceConnectionsInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> mapperSourceConnectionsInfoResponseToKotlin(args0) })
            })
        })

    /**
     * Status of the CDC as to if it is running or stopped.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of target connections that can be used as sources in the CDC.
     */
    public val targetConnectionsInfo: Output<List<MapperTargetConnectionsInfoResponse>>
        get() = javaResource.targetConnectionsInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> mapperTargetConnectionsInfoResponseToKotlin(args0) })
            })
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ChangeDataCaptureMapper : ResourceMapper<ChangeDataCapture> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datafactory.ChangeDataCapture::class == javaResource::class

    override fun map(javaResource: Resource): ChangeDataCapture = ChangeDataCapture(
        javaResource as
            com.pulumi.azurenative.datafactory.ChangeDataCapture,
    )
}

/**
 * @see [ChangeDataCapture].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ChangeDataCapture].
 */
public suspend fun changeDataCapture(
    name: String,
    block: suspend ChangeDataCaptureResourceBuilder.() -> Unit,
): ChangeDataCapture {
    val builder = ChangeDataCaptureResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ChangeDataCapture].
 * @param name The _unique_ name of the resulting resource.
 */
public fun changeDataCapture(name: String): ChangeDataCapture {
    val builder = ChangeDataCaptureResourceBuilder()
    builder.name(name)
    return builder.build()
}
