@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.CredentialOperationArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.inputs.ManagedIdentityCredentialArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.ManagedIdentityCredentialArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Credential resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### Credentials_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var credentialOperation = new AzureNative.DataFactory.CredentialOperation("credentialOperation", new()
 *     {
 *         CredentialName = "exampleCredential",
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.ManagedIdentityCredentialArgs
 *         {
 *             ResourceId = "/subscriptions/12345678-1234-1234-1234-12345678abc/resourcegroups/exampleResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/exampleUami",
 *             Type = "ManagedIdentity",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datafactory.NewCredentialOperation(ctx, "credentialOperation", &datafactory.CredentialOperationArgs{
 * CredentialName: pulumi.String("exampleCredential"),
 * FactoryName: pulumi.String("exampleFactoryName"),
 * Properties: interface{}{
 * ResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-12345678abc/resourcegroups/exampleResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/exampleUami"),
 * Type: pulumi.String("ManagedIdentity"),
 * },
 * ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.CredentialOperation;
 * import com.pulumi.azurenative.datafactory.CredentialOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var credentialOperation = new CredentialOperation("credentialOperation", CredentialOperationArgs.builder()
 *             .credentialName("exampleCredential")
 *             .factoryName("exampleFactoryName")
 *             .properties(Map.ofEntries(
 *                 Map.entry("resourceId", "/subscriptions/12345678-1234-1234-1234-12345678abc/resourcegroups/exampleResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/exampleUami"),
 *                 Map.entry("type", "ManagedIdentity")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:CredentialOperation exampleCredential /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/credentials/{credentialName}
 * ```
 * @property credentialName Credential name
 * @property factoryName The factory name.
 * @property properties Managed Identity Credential properties.
 * @property resourceGroupName The resource group name.
 */
public data class CredentialOperationArgs(
    public val credentialName: Output<String>? = null,
    public val factoryName: Output<String>? = null,
    public val properties: Output<ManagedIdentityCredentialArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.CredentialOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.CredentialOperationArgs =
        com.pulumi.azurenative.datafactory.CredentialOperationArgs.builder()
            .credentialName(credentialName?.applyValue({ args0 -> args0 }))
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CredentialOperationArgs].
 */
@PulumiTagMarker
public class CredentialOperationArgsBuilder internal constructor() {
    private var credentialName: Output<String>? = null

    private var factoryName: Output<String>? = null

    private var properties: Output<ManagedIdentityCredentialArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Credential name
     */
    @JvmName("jkodacmsxbijpteh")
    public suspend fun credentialName(`value`: Output<String>) {
        this.credentialName = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("dymuwmpoxmxsjxxg")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value Managed Identity Credential properties.
     */
    @JvmName("ohadcknjnehngqth")
    public suspend fun properties(`value`: Output<ManagedIdentityCredentialArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("avaxippgmxwsvgbd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Credential name
     */
    @JvmName("ddrujwoyuivkaalb")
    public suspend fun credentialName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentialName = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("wjtmpfijwitbkalj")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value Managed Identity Credential properties.
     */
    @JvmName("xnflfemujsjxwlet")
    public suspend fun properties(`value`: ManagedIdentityCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Managed Identity Credential properties.
     */
    @JvmName("yqhcuaatqmrhojjh")
    public suspend fun properties(argument: suspend ManagedIdentityCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("rifrfouwolfrirur")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CredentialOperationArgs = CredentialOperationArgs(
        credentialName = credentialName,
        factoryName = factoryName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
