@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.FactoryArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.datafactory.kotlin.inputs.EncryptionConfigurationArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.EncryptionConfigurationArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.FactoryGitHubConfigurationArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.FactoryIdentityArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.FactoryIdentityArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.FactoryVSTSConfigurationArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GlobalParameterSpecificationArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GlobalParameterSpecificationArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.PurviewConfigurationArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.PurviewConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Factory resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * Other available API versions: 2017-09-01-preview.
 * ## Example Usage
 * ### Factories_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var factory = new AzureNative.DataFactory.Factory("factory", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         Location = "East US",
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewFactory(ctx, "factory", &datafactory.FactoryArgs{
 * 			FactoryName:       pulumi.String("exampleFactoryName"),
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.Factory;
 * import com.pulumi.azurenative.datafactory.FactoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var factory = new Factory("factory", FactoryArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .location("East US")
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:Factory exampleFactoryName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}
 * ```
 * @property encryption Properties to enable Customer Managed Key for the factory.
 * @property factoryName The factory name.
 * @property globalParameters List of parameters for factory.
 * @property identity Managed service identity of the factory.
 * @property location The resource location.
 * @property publicNetworkAccess Whether or not public network access is allowed for the data factory.
 * @property purviewConfiguration Purview information of the factory.
 * @property repoConfiguration Git repo information of the factory.
 * @property resourceGroupName The resource group name.
 * @property tags The resource tags.
 */
public data class FactoryArgs(
    public val encryption: Output<EncryptionConfigurationArgs>? = null,
    public val factoryName: Output<String>? = null,
    public val globalParameters: Output<Map<String, GlobalParameterSpecificationArgs>>? = null,
    public val identity: Output<FactoryIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val purviewConfiguration: Output<PurviewConfigurationArgs>? = null,
    public val repoConfiguration:
    Output<Either<FactoryGitHubConfigurationArgs, FactoryVSTSConfigurationArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.FactoryArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.FactoryArgs =
        com.pulumi.azurenative.datafactory.FactoryArgs.builder()
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .globalParameters(
                globalParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .purviewConfiguration(
                purviewConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .repoConfiguration(
                repoConfiguration?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FactoryArgs].
 */
@PulumiTagMarker
public class FactoryArgsBuilder internal constructor() {
    private var encryption: Output<EncryptionConfigurationArgs>? = null

    private var factoryName: Output<String>? = null

    private var globalParameters: Output<Map<String, GlobalParameterSpecificationArgs>>? = null

    private var identity: Output<FactoryIdentityArgs>? = null

    private var location: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var purviewConfiguration: Output<PurviewConfigurationArgs>? = null

    private var repoConfiguration:
        Output<Either<FactoryGitHubConfigurationArgs, FactoryVSTSConfigurationArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Properties to enable Customer Managed Key for the factory.
     */
    @JvmName("desmvitrmrffctok")
    public suspend fun encryption(`value`: Output<EncryptionConfigurationArgs>) {
        this.encryption = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("ljnvycgcklusklwj")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value List of parameters for factory.
     */
    @JvmName("dtrkxnieeqaudwhw")
    public suspend
    fun globalParameters(`value`: Output<Map<String, GlobalParameterSpecificationArgs>>) {
        this.globalParameters = value
    }

    /**
     * @param value Managed service identity of the factory.
     */
    @JvmName("ydfywkndcyuonjrv")
    public suspend fun identity(`value`: Output<FactoryIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("ybfndkvmydqrysia")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Whether or not public network access is allowed for the data factory.
     */
    @JvmName("cwrbdlsbavtukmew")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Purview information of the factory.
     */
    @JvmName("uyurhcjieuebbckq")
    public suspend fun purviewConfiguration(`value`: Output<PurviewConfigurationArgs>) {
        this.purviewConfiguration = value
    }

    /**
     * @param value Git repo information of the factory.
     */
    @JvmName("otfcyacdtmiwnxny")
    public suspend
    fun repoConfiguration(`value`: Output<Either<FactoryGitHubConfigurationArgs, FactoryVSTSConfigurationArgs>>) {
        this.repoConfiguration = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qookvisiwkgnvfsv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("ntgmijykpilknkjv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Properties to enable Customer Managed Key for the factory.
     */
    @JvmName("utinndhpfvnkfxvj")
    public suspend fun encryption(`value`: EncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument Properties to enable Customer Managed Key for the factory.
     */
    @JvmName("haxlqsakmeakvntp")
    public suspend fun encryption(argument: suspend EncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("ddvlcqiwxapkxkqe")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value List of parameters for factory.
     */
    @JvmName("qbilkyuhxpmurvii")
    public suspend fun globalParameters(`value`: Map<String, GlobalParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalParameters = mapped
    }

    /**
     * @param argument List of parameters for factory.
     */
    @JvmName("agggolcpxqbopaps")
    public suspend fun globalParameters(
        vararg
        argument: Pair<String, suspend GlobalParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                GlobalParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.globalParameters = mapped
    }

    /**
     * @param values List of parameters for factory.
     */
    @JvmName("sqitmyliawuwdnxy")
    public fun globalParameters(vararg values: Pair<String, GlobalParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.globalParameters = mapped
    }

    /**
     * @param value Managed service identity of the factory.
     */
    @JvmName("mmqokqtwmiuqjsvl")
    public suspend fun identity(`value`: FactoryIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity of the factory.
     */
    @JvmName("fketyubasfuyjtag")
    public suspend fun identity(argument: suspend FactoryIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = FactoryIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("nyyerghaynjvvcdr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for the data factory.
     */
    @JvmName("bbydoimwygdyvafa")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for the data factory.
     */
    @JvmName("uwdohuhdwfqndukr")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for the data factory.
     */
    @JvmName("quorjahwhvacmhxj")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Purview information of the factory.
     */
    @JvmName("hljlxrssvdymwuds")
    public suspend fun purviewConfiguration(`value`: PurviewConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purviewConfiguration = mapped
    }

    /**
     * @param argument Purview information of the factory.
     */
    @JvmName("wngqsfuriyjvoilb")
    public suspend
    fun purviewConfiguration(argument: suspend PurviewConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PurviewConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.purviewConfiguration = mapped
    }

    /**
     * @param value Git repo information of the factory.
     */
    @JvmName("inmhbrhpxowwvebo")
    public suspend
    fun repoConfiguration(`value`: Either<FactoryGitHubConfigurationArgs, FactoryVSTSConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repoConfiguration = mapped
    }

    /**
     * @param value Git repo information of the factory.
     */
    @JvmName("iynrvnxkosbfrwjd")
    public fun repoConfiguration(`value`: FactoryGitHubConfigurationArgs) {
        val toBeMapped = Either.ofLeft<FactoryGitHubConfigurationArgs,
            FactoryVSTSConfigurationArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repoConfiguration = mapped
    }

    /**
     * @param value Git repo information of the factory.
     */
    @JvmName("tcchdpvlhfwqwcjb")
    public fun repoConfiguration(`value`: FactoryVSTSConfigurationArgs) {
        val toBeMapped = Either.ofRight<FactoryGitHubConfigurationArgs,
            FactoryVSTSConfigurationArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repoConfiguration = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jirguoakrkocjfbt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("nsgkagleeykgcaob")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("djdmxwkndjnunvwl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FactoryArgs = FactoryArgs(
        encryption = encryption,
        factoryName = factoryName,
        globalParameters = globalParameters,
        identity = identity,
        location = location,
        publicNetworkAccess = publicNetworkAccess,
        purviewConfiguration = purviewConfiguration,
        repoConfiguration = repoConfiguration,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
