@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LinkedService].
 */
@PulumiTagMarker
public class LinkedServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkedServiceArgs = LinkedServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkedServiceArgsBuilder.() -> Unit) {
        val builder = LinkedServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LinkedService {
        val builtJavaResource =
            com.pulumi.azurenative.datafactory.LinkedService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LinkedService(builtJavaResource)
    }
}

/**
 * Linked service resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### LinkedServices_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedService = new AzureNative.DataFactory.LinkedService("linkedService", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         LinkedServiceName = "exampleLinkedService",
 *         Properties = new AzureNative.DataFactory.Inputs.AzureStorageLinkedServiceArgs
 *         {
 *             ConnectionString =
 *             {
 *                 { "type", "SecureString" },
 *                 { "value", "DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>" },
 *             },
 *             Type = "AzureStorage",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewLinkedService(ctx, "linkedService", &datafactory.LinkedServiceArgs{
 * 			FactoryName:       pulumi.String("exampleFactoryName"),
 * 			LinkedServiceName: pulumi.String("exampleLinkedService"),
 * 			Properties: datafactory.AzureStorageLinkedService{
 * 				ConnectionString: map[string]interface{}{
 * 					"type":  "SecureString",
 * 					"value": "DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>",
 * 				},
 * 				Type: "AzureStorage",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.LinkedService;
 * import com.pulumi.azurenative.datafactory.LinkedServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedService = new LinkedService("linkedService", LinkedServiceArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .linkedServiceName("exampleLinkedService")
 *             .properties(Map.ofEntries(
 *                 Map.entry("connectionString", AmazonMWSLinkedServiceArgs.builder()
 *                     .type("SecureString")
 *                     .value("DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>")
 *                     .build()),
 *                 Map.entry("type", "AzureStorage")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### LinkedServices_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedService = new AzureNative.DataFactory.LinkedService("linkedService", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         LinkedServiceName = "exampleLinkedService",
 *         Properties = new AzureNative.DataFactory.Inputs.AzureStorageLinkedServiceArgs
 *         {
 *             ConnectionString =
 *             {
 *                 { "type", "SecureString" },
 *                 { "value", "DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>" },
 *             },
 *             Description = "Example description",
 *             Type = "AzureStorage",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewLinkedService(ctx, "linkedService", &datafactory.LinkedServiceArgs{
 * 			FactoryName:       pulumi.String("exampleFactoryName"),
 * 			LinkedServiceName: pulumi.String("exampleLinkedService"),
 * 			Properties: datafactory.AzureStorageLinkedService{
 * 				ConnectionString: map[string]interface{}{
 * 					"type":  "SecureString",
 * 					"value": "DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>",
 * 				},
 * 				Description: "Example description",
 * 				Type:        "AzureStorage",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.LinkedService;
 * import com.pulumi.azurenative.datafactory.LinkedServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedService = new LinkedService("linkedService", LinkedServiceArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .linkedServiceName("exampleLinkedService")
 *             .properties(Map.ofEntries(
 *                 Map.entry("connectionString", AmazonMWSLinkedServiceArgs.builder()
 *                     .type("SecureString")
 *                     .value("DefaultEndpointsProtocol=https;AccountName=examplestorageaccount;AccountKey=<storage key>")
 *                     .build()),
 *                 Map.entry("description", "Example description"),
 *                 Map.entry("type", "AzureStorage")
 *             ))
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:LinkedService exampleLinkedService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/linkedservices/{linkedServiceName}
 * ```
 */
public class LinkedService internal constructor(
    override val javaResource: com.pulumi.azurenative.datafactory.LinkedService,
) : KotlinCustomResource(javaResource, LinkedServiceMapper) {
    /**
     * Etag identifies change in the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of linked service.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LinkedServiceMapper : ResourceMapper<LinkedService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datafactory.LinkedService::class == javaResource::class

    override fun map(javaResource: Resource): LinkedService = LinkedService(
        javaResource as
            com.pulumi.azurenative.datafactory.LinkedService,
    )
}

/**
 * @see [LinkedService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LinkedService].
 */
public suspend fun linkedService(
    name: String,
    block: suspend LinkedServiceResourceBuilder.() -> Unit,
): LinkedService {
    val builder = LinkedServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LinkedService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linkedService(name: String): LinkedService {
    val builder = LinkedServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
