@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.PipelineArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.inputs.ParameterSpecificationArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.ParameterSpecificationArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.PipelineFolderArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.PipelineFolderArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.PipelinePolicyArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.PipelinePolicyArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.VariableSpecificationArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.VariableSpecificationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Pipeline resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * @property activities List of activities in pipeline.
 * @property annotations List of tags that can be used for describing the Pipeline.
 * @property concurrency The max number of concurrent runs for the pipeline.
 * @property description The description of the pipeline.
 * @property factoryName The factory name.
 * @property folder The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
 * @property parameters List of parameters for pipeline.
 * @property pipelineName The pipeline name.
 * @property policy Pipeline Policy.
 * @property resourceGroupName The resource group name.
 * @property runDimensions Dimensions emitted by Pipeline.
 * @property variables List of variables for pipeline.
 */
public data class PipelineArgs(
    public val activities: Output<List<Any>>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val concurrency: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val factoryName: Output<String>? = null,
    public val folder: Output<PipelineFolderArgs>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val pipelineName: Output<String>? = null,
    public val policy: Output<PipelinePolicyArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runDimensions: Output<Map<String, Any>>? = null,
    public val variables: Output<Map<String, VariableSpecificationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.PipelineArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.PipelineArgs =
        com.pulumi.azurenative.datafactory.PipelineArgs.builder()
            .activities(activities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .concurrency(concurrency?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .pipelineName(pipelineName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runDimensions(
                runDimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .variables(
                variables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PipelineArgs].
 */
@PulumiTagMarker
public class PipelineArgsBuilder internal constructor() {
    private var activities: Output<List<Any>>? = null

    private var annotations: Output<List<Any>>? = null

    private var concurrency: Output<Int>? = null

    private var description: Output<String>? = null

    private var factoryName: Output<String>? = null

    private var folder: Output<PipelineFolderArgs>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var pipelineName: Output<String>? = null

    private var policy: Output<PipelinePolicyArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var runDimensions: Output<Map<String, Any>>? = null

    private var variables: Output<Map<String, VariableSpecificationArgs>>? = null

    /**
     * @param value List of activities in pipeline.
     */
    @JvmName("jweskmgrhdxalbwe")
    public suspend fun activities(`value`: Output<List<Any>>) {
        this.activities = value
    }

    @JvmName("ivrlhsakxglneeux")
    public suspend fun activities(vararg values: Output<Any>) {
        this.activities = Output.all(values.asList())
    }

    /**
     * @param values List of activities in pipeline.
     */
    @JvmName("bvispjjyywhhxgmy")
    public suspend fun activities(values: List<Output<Any>>) {
        this.activities = Output.all(values)
    }

    /**
     * @param value List of tags that can be used for describing the Pipeline.
     */
    @JvmName("urudlogjoidhujei")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("kyxerltmugdtatfh")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Pipeline.
     */
    @JvmName("wepbooqjionmfsuu")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The max number of concurrent runs for the pipeline.
     */
    @JvmName("rxbtkwwcfclmlnyr")
    public suspend fun concurrency(`value`: Output<Int>) {
        this.concurrency = value
    }

    /**
     * @param value The description of the pipeline.
     */
    @JvmName("qihpucbnvualopxj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("ackjrhcbfikmsfke")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
     */
    @JvmName("sxdaukjqreuwprgc")
    public suspend fun folder(`value`: Output<PipelineFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value List of parameters for pipeline.
     */
    @JvmName("tkeidadyqpjwsnut")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The pipeline name.
     */
    @JvmName("kmuhmouwfauxukmb")
    public suspend fun pipelineName(`value`: Output<String>) {
        this.pipelineName = value
    }

    /**
     * @param value Pipeline Policy.
     */
    @JvmName("ecbjbalqopjdvpjw")
    public suspend fun policy(`value`: Output<PipelinePolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("lrlebwvgppqncfhf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Dimensions emitted by Pipeline.
     */
    @JvmName("aelogshmiipfatpl")
    public suspend fun runDimensions(`value`: Output<Map<String, Any>>) {
        this.runDimensions = value
    }

    /**
     * @param value List of variables for pipeline.
     */
    @JvmName("qmatifbnvskqsmxo")
    public suspend fun variables(`value`: Output<Map<String, VariableSpecificationArgs>>) {
        this.variables = value
    }

    /**
     * @param value List of activities in pipeline.
     */
    @JvmName("jhghgfqhfthusnpi")
    public suspend fun activities(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activities = mapped
    }

    /**
     * @param values List of activities in pipeline.
     */
    @JvmName("xuaklaselrhblwjs")
    public suspend fun activities(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activities = mapped
    }

    /**
     * @param value List of tags that can be used for describing the Pipeline.
     */
    @JvmName("sufvshgyvplsveec")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Pipeline.
     */
    @JvmName("udjharlfxwtymsuv")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The max number of concurrent runs for the pipeline.
     */
    @JvmName("jqvlbagsphquutob")
    public suspend fun concurrency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.concurrency = mapped
    }

    /**
     * @param value The description of the pipeline.
     */
    @JvmName("tstxigsymtwwfxio")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("varecwmdsdshbpdu")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
     */
    @JvmName("kqcxdwaqvtcgvvex")
    public suspend fun folder(`value`: PipelineFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
     */
    @JvmName("obgoijehcwlolmtj")
    public suspend fun folder(argument: suspend PipelineFolderArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value List of parameters for pipeline.
     */
    @JvmName("wdbjhyuvpqsbblee")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument List of parameters for pipeline.
     */
    @JvmName("gqnjynuavjlnksff")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values List of parameters for pipeline.
     */
    @JvmName("jghhlbugmbornkps")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The pipeline name.
     */
    @JvmName("bmothfdjpenyafsi")
    public suspend fun pipelineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineName = mapped
    }

    /**
     * @param value Pipeline Policy.
     */
    @JvmName("lvweautbajmprmck")
    public suspend fun policy(`value`: PipelinePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Pipeline Policy.
     */
    @JvmName("qtlaiqjrmruhwstf")
    public suspend fun policy(argument: suspend PipelinePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = PipelinePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("unadhnrdgvqahmyp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Dimensions emitted by Pipeline.
     */
    @JvmName("ovpxhddknfgoibdw")
    public suspend fun runDimensions(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runDimensions = mapped
    }

    /**
     * @param values Dimensions emitted by Pipeline.
     */
    @JvmName("dbjcgxedwtjajfsx")
    public fun runDimensions(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runDimensions = mapped
    }

    /**
     * @param value List of variables for pipeline.
     */
    @JvmName("fdfjtmxqjuqqhkrt")
    public suspend fun variables(`value`: Map<String, VariableSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    /**
     * @param argument List of variables for pipeline.
     */
    @JvmName("nytooikmaylakwnr")
    public suspend fun variables(
        vararg
        argument: Pair<String, suspend VariableSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                VariableSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.variables = mapped
    }

    /**
     * @param values List of variables for pipeline.
     */
    @JvmName("jomouylxauxtixtc")
    public fun variables(vararg values: Pair<String, VariableSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variables = mapped
    }

    internal fun build(): PipelineArgs = PipelineArgs(
        activities = activities,
        annotations = annotations,
        concurrency = concurrency,
        description = description,
        factoryName = factoryName,
        folder = folder,
        parameters = parameters,
        pipelineName = pipelineName,
        policy = policy,
        resourceGroupName = resourceGroupName,
        runDimensions = runDimensions,
        variables = variables,
    )
}
