@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication type to be used to connect to the HTTP server.
 */
public enum class HttpAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.HttpAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.HttpAuthenticationType> {
    Basic(com.pulumi.azurenative.datafactory.enums.HttpAuthenticationType.Basic),
    Anonymous(com.pulumi.azurenative.datafactory.enums.HttpAuthenticationType.Anonymous),
    Digest(com.pulumi.azurenative.datafactory.enums.HttpAuthenticationType.Digest),
    Windows(com.pulumi.azurenative.datafactory.enums.HttpAuthenticationType.Windows),
    ClientCertificate(com.pulumi.azurenative.datafactory.enums.HttpAuthenticationType.ClientCertificate),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.HttpAuthenticationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.HttpAuthenticationType):
            HttpAuthenticationType = HttpAuthenticationType.values().first { it.javaValue == javaType }
    }
}
