@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The authentication type to be used to connect to the FTP server.
 */
public enum class SftpAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.SftpAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.SftpAuthenticationType> {
    Basic(com.pulumi.azurenative.datafactory.enums.SftpAuthenticationType.Basic),
    SshPublicKey(com.pulumi.azurenative.datafactory.enums.SftpAuthenticationType.SshPublicKey),
    MultiFactor(com.pulumi.azurenative.datafactory.enums.SftpAuthenticationType.MultiFactor),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.SftpAuthenticationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.SftpAuthenticationType):
            SftpAuthenticationType = SftpAuthenticationType.values().first { it.javaValue == javaType }
    }
}
