@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of SSIS package location.
 */
public enum class SsisPackageLocationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.SsisPackageLocationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.SsisPackageLocationType> {
    SSISDB(com.pulumi.azurenative.datafactory.enums.SsisPackageLocationType.SSISDB),
    File(com.pulumi.azurenative.datafactory.enums.SsisPackageLocationType.File),
    InlinePackage(com.pulumi.azurenative.datafactory.enums.SsisPackageLocationType.InlinePackage),
    PackageStore(com.pulumi.azurenative.datafactory.enums.SsisPackageLocationType.PackageStore),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.SsisPackageLocationType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.SsisPackageLocationType):
            SsisPackageLocationType =
            SsisPackageLocationType.values().first { it.javaValue == javaType }
    }
}
