@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AmazonS3CompatibleLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The location of Amazon S3 Compatible dataset.
 * @property bucketName Specify the bucketName of Amazon S3 Compatible. Type: string (or Expression with resultType string)
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'AmazonS3CompatibleLocation'.
 * @property version Specify the version of Amazon S3 Compatible. Type: string (or Expression with resultType string).
 */
public data class AmazonS3CompatibleLocationArgs(
    public val bucketName: Output<Any>? = null,
    public val fileName: Output<Any>? = null,
    public val folderPath: Output<Any>? = null,
    public val type: Output<String>,
    public val version: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AmazonS3CompatibleLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AmazonS3CompatibleLocationArgs =
        com.pulumi.azurenative.datafactory.inputs.AmazonS3CompatibleLocationArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmazonS3CompatibleLocationArgs].
 */
@PulumiTagMarker
public class AmazonS3CompatibleLocationArgsBuilder internal constructor() {
    private var bucketName: Output<Any>? = null

    private var fileName: Output<Any>? = null

    private var folderPath: Output<Any>? = null

    private var type: Output<String>? = null

    private var version: Output<Any>? = null

    /**
     * @param value Specify the bucketName of Amazon S3 Compatible. Type: string (or Expression with resultType string)
     */
    @JvmName("cxvxmhhqwyljqybl")
    public suspend fun bucketName(`value`: Output<Any>) {
        this.bucketName = value
    }

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("ihwtoettnoqejmaa")
    public suspend fun fileName(`value`: Output<Any>) {
        this.fileName = value
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("dsrdagujxarlsnbp")
    public suspend fun folderPath(`value`: Output<Any>) {
        this.folderPath = value
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'AmazonS3CompatibleLocation'.
     */
    @JvmName("kypopucagjgcfgof")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specify the version of Amazon S3 Compatible. Type: string (or Expression with resultType string).
     */
    @JvmName("aliivvalqyrrgjxj")
    public suspend fun version(`value`: Output<Any>) {
        this.version = value
    }

    /**
     * @param value Specify the bucketName of Amazon S3 Compatible. Type: string (or Expression with resultType string)
     */
    @JvmName("yfnvdjftajblyfiv")
    public suspend fun bucketName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("aestbponncvbqodr")
    public suspend fun fileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("dfiqcscpakuehdhq")
    public suspend fun folderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'AmazonS3CompatibleLocation'.
     */
    @JvmName("yifbccvylooywvqg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specify the version of Amazon S3 Compatible. Type: string (or Expression with resultType string).
     */
    @JvmName("hwuyfoubfkkimqgv")
    public suspend fun version(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): AmazonS3CompatibleLocationArgs = AmazonS3CompatibleLocationArgs(
        bucketName = bucketName,
        fileName = fileName,
        folderPath = folderPath,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
