@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AmazonS3DatasetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A single Amazon Simple Storage Service (S3) object or a set of S3 objects.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property bucketName The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
 * @property compression The data compression method used for the Amazon S3 object.
 * @property description Dataset description.
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property format The format of files.
 * @property key The key of the Amazon S3 object. Type: string (or Expression with resultType string).
 * @property linkedServiceName Linked service reference.
 * @property modifiedDatetimeEnd The end of S3 object's modified datetime. Type: string (or Expression with resultType string).
 * @property modifiedDatetimeStart The start of S3 object's modified datetime. Type: string (or Expression with resultType string).
 * @property parameters Parameters for dataset.
 * @property prefix The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property type Type of dataset.
 * Expected value is 'AmazonS3Object'.
 * @property version The version for the S3 object. Type: string (or Expression with resultType string).
 */
public data class AmazonS3DatasetArgs(
    public val annotations: Output<List<Any>>? = null,
    public val bucketName: Output<Any>,
    public val compression: Output<DatasetCompressionArgs>? = null,
    public val description: Output<String>? = null,
    public val folder: Output<DatasetFolderArgs>? = null,
    public val format: Output<Any>? = null,
    public val key: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val modifiedDatetimeEnd: Output<Any>? = null,
    public val modifiedDatetimeStart: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val prefix: Output<Any>? = null,
    public val schema: Output<Any>? = null,
    public val structure: Output<Any>? = null,
    public val type: Output<String>,
    public val version: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AmazonS3DatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AmazonS3DatasetArgs =
        com.pulumi.azurenative.datafactory.inputs.AmazonS3DatasetArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .compression(compression?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .format(format?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .modifiedDatetimeEnd(modifiedDatetimeEnd?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeStart(modifiedDatetimeStart?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0 }))
            .structure(structure?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmazonS3DatasetArgs].
 */
@PulumiTagMarker
public class AmazonS3DatasetArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var bucketName: Output<Any>? = null

    private var compression: Output<DatasetCompressionArgs>? = null

    private var description: Output<String>? = null

    private var folder: Output<DatasetFolderArgs>? = null

    private var format: Output<Any>? = null

    private var key: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var modifiedDatetimeEnd: Output<Any>? = null

    private var modifiedDatetimeStart: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var prefix: Output<Any>? = null

    private var schema: Output<Any>? = null

    private var structure: Output<Any>? = null

    private var type: Output<String>? = null

    private var version: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("jkngsohptajnmolh")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("lgavtymplciaewyp")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("refehyrfooygnnkd")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
     */
    @JvmName("rjpoheuwpoukqmoe")
    public suspend fun bucketName(`value`: Output<Any>) {
        this.bucketName = value
    }

    /**
     * @param value The data compression method used for the Amazon S3 object.
     */
    @JvmName("oampfgnileejccyt")
    public suspend fun compression(`value`: Output<DatasetCompressionArgs>) {
        this.compression = value
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("uamsixhewnfxenff")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("itushatnodbfymwj")
    public suspend fun folder(`value`: Output<DatasetFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value The format of files.
     */
    @JvmName("yjdrrphrdsiwffui")
    public suspend fun format(`value`: Output<Any>) {
        this.format = value
    }

    /**
     * @param value The key of the Amazon S3 object. Type: string (or Expression with resultType string).
     */
    @JvmName("iimmuwyvrkjwjhhb")
    public suspend fun key(`value`: Output<Any>) {
        this.key = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("egninttrqxxdojgu")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value The end of S3 object's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("ighpwgiokmlrnxdw")
    public suspend fun modifiedDatetimeEnd(`value`: Output<Any>) {
        this.modifiedDatetimeEnd = value
    }

    /**
     * @param value The start of S3 object's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("tjfatjqhhkkhkalm")
    public suspend fun modifiedDatetimeStart(`value`: Output<Any>) {
        this.modifiedDatetimeStart = value
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("ynrxunlbaerwnerg")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
     */
    @JvmName("gmcpuccfbxygqddm")
    public suspend fun prefix(`value`: Output<Any>) {
        this.prefix = value
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("vysdixywmmhplxel")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("yckgghbkhfqxqmpg")
    public suspend fun structure(`value`: Output<Any>) {
        this.structure = value
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'AmazonS3Object'.
     */
    @JvmName("mdragjgnbjvuosca")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The version for the S3 object. Type: string (or Expression with resultType string).
     */
    @JvmName("gwyaspgmgpcfufks")
    public suspend fun version(`value`: Output<Any>) {
        this.version = value
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("pmgeepoaxjmlouip")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("uidmmrcybxfjfnfc")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
     */
    @JvmName("rfnhydvulqwjxqwj")
    public suspend fun bucketName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The data compression method used for the Amazon S3 object.
     */
    @JvmName("imtmbovbhpeulbuk")
    public suspend fun compression(`value`: DatasetCompressionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param argument The data compression method used for the Amazon S3 object.
     */
    @JvmName("blbmqxypiywnrxss")
    public suspend fun compression(argument: suspend DatasetCompressionArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetCompressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.compression = mapped
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("mqhrmdnpmvteqtke")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("xmpxqwwkhuahchos")
    public suspend fun folder(`value`: DatasetFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("cekrvsspunggeuuf")
    public suspend fun folder(argument: suspend DatasetFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value The format of files.
     */
    @JvmName("tivmoiaxlrllbdrg")
    public suspend fun format(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The key of the Amazon S3 object. Type: string (or Expression with resultType string).
     */
    @JvmName("fnateoiypypexoxp")
    public suspend fun key(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("jigwrtvrppgtcbeh")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("bhjqkvecinqsbtfm")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value The end of S3 object's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("tantcnarurfeohtj")
    public suspend fun modifiedDatetimeEnd(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeEnd = mapped
    }

    /**
     * @param value The start of S3 object's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("tasaiindofmqcdhf")
    public suspend fun modifiedDatetimeStart(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeStart = mapped
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("jcbegiwiodofoqeq")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for dataset.
     */
    @JvmName("knxmsngsmauexwcx")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for dataset.
     */
    @JvmName("nhmnyqhjvycbofkb")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
     */
    @JvmName("nbngmqfdkglfxhst")
    public suspend fun prefix(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("fjcxhfhitnhfsdmm")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("jrjstamskpcxuage")
    public suspend fun structure(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'AmazonS3Object'.
     */
    @JvmName("kqijjvbqunqydsdk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The version for the S3 object. Type: string (or Expression with resultType string).
     */
    @JvmName("dyjaygwivkdrwrim")
    public suspend fun version(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): AmazonS3DatasetArgs = AmazonS3DatasetArgs(
        annotations = annotations,
        bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        compression = compression,
        description = description,
        folder = folder,
        format = format,
        key = key,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        modifiedDatetimeEnd = modifiedDatetimeEnd,
        modifiedDatetimeStart = modifiedDatetimeStart,
        parameters = parameters,
        prefix = prefix,
        schema = schema,
        structure = structure,
        type = type ?: throw PulumiNullFieldException("type"),
        version = version,
    )
}
