@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AppFiguresLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for AppFigures.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clientKey The client key for the AppFigures source.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property parameters Parameters for linked service.
 * @property password The password of the AppFigures source.
 * @property type Type of linked service.
 * Expected value is 'AppFigures'.
 * @property userName The username of the Appfigures source. Type: string (or Expression with resultType string).
 */
public data class AppFiguresLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val clientKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>,
    public val type: Output<String>,
    public val userName: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AppFiguresLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AppFiguresLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AppFiguresLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clientKey(
                clientKey.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppFiguresLinkedServiceArgs].
 */
@PulumiTagMarker
public class AppFiguresLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var clientKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("gclykhssqoktdpdc")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("drojjwapbxvfrxcl")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("eeknwxbviqpwccoo")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The client key for the AppFigures source.
     */
    @JvmName("mrwjxdldcyhoulij")
    public suspend
    fun clientKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clientKey = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("txmkkaiiahpmcuhb")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("jhkcrysfxvqxiokr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ubgxhtdffbirumsq")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The password of the AppFigures source.
     */
    @JvmName("tultgxrdwjtqkehr")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AppFigures'.
     */
    @JvmName("vtoxnhyoyniwdnoa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The username of the Appfigures source. Type: string (or Expression with resultType string).
     */
    @JvmName("mkmmrgvdyhajtske")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("uwutqawcsaxlsvtu")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("xgfgtjwxgpsftavh")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The client key for the AppFigures source.
     */
    @JvmName("tuvtytwwomssxhos")
    public suspend
    fun clientKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientKey = mapped
    }

    /**
     * @param value The client key for the AppFigures source.
     */
    @JvmName("hyhcferewjnxgfhb")
    public fun clientKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientKey = mapped
    }

    /**
     * @param value The client key for the AppFigures source.
     */
    @JvmName("rkfaleqowpcaubkv")
    public fun clientKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientKey = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("tliggfcpsjhtscuc")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("bdndtwujjypshhxm")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ysmagjqitvhilhpe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("hkyflxctsobqcehu")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("cyotsafxphqwdbch")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("cukehnppuunhdhnc")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password of the AppFigures source.
     */
    @JvmName("pvsqinbpavlwjiif")
    public suspend fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password of the AppFigures source.
     */
    @JvmName("idkdqksxpjwwqlqo")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password of the AppFigures source.
     */
    @JvmName("mfoejsdhxhibfdew")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AppFigures'.
     */
    @JvmName("nynpmlnixindqdxn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The username of the Appfigures source. Type: string (or Expression with resultType string).
     */
    @JvmName("qsqhbnutrxkhitjw")
    public suspend fun userName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): AppFiguresLinkedServiceArgs = AppFiguresLinkedServiceArgs(
        annotations = annotations,
        clientKey = clientKey ?: throw PulumiNullFieldException("clientKey"),
        connectVia = connectVia,
        description = description,
        parameters = parameters,
        password = password ?: throw PulumiNullFieldException("password"),
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
