@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AvroFormatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The data stored in Avro format.
 * @property deserializer Deserializer. Type: string (or Expression with resultType string).
 * @property serializer Serializer. Type: string (or Expression with resultType string).
 * @property type Type of dataset storage format.
 * Expected value is 'AvroFormat'.
 */
public data class AvroFormatArgs(
    public val deserializer: Output<Any>? = null,
    public val serializer: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AvroFormatArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AvroFormatArgs =
        com.pulumi.azurenative.datafactory.inputs.AvroFormatArgs.builder()
            .deserializer(deserializer?.applyValue({ args0 -> args0 }))
            .serializer(serializer?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AvroFormatArgs].
 */
@PulumiTagMarker
public class AvroFormatArgsBuilder internal constructor() {
    private var deserializer: Output<Any>? = null

    private var serializer: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Deserializer. Type: string (or Expression with resultType string).
     */
    @JvmName("wevsxbucobyjvfxr")
    public suspend fun deserializer(`value`: Output<Any>) {
        this.deserializer = value
    }

    /**
     * @param value Serializer. Type: string (or Expression with resultType string).
     */
    @JvmName("vgxqybyswjmutolw")
    public suspend fun serializer(`value`: Output<Any>) {
        this.serializer = value
    }

    /**
     * @param value Type of dataset storage format.
     * Expected value is 'AvroFormat'.
     */
    @JvmName("yaadofdtjtyvgpvp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Deserializer. Type: string (or Expression with resultType string).
     */
    @JvmName("nfidlspbyufkbltg")
    public suspend fun deserializer(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deserializer = mapped
    }

    /**
     * @param value Serializer. Type: string (or Expression with resultType string).
     */
    @JvmName("qvfusmajormsycan")
    public suspend fun serializer(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serializer = mapped
    }

    /**
     * @param value Type of dataset storage format.
     * Expected value is 'AvroFormat'.
     */
    @JvmName("jfwxremwccqrarpa")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AvroFormatArgs = AvroFormatArgs(
        deserializer = deserializer,
        serializer = serializer,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
