@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzPowerShellSetupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The express custom setup of installing Azure PowerShell.
 * @property type The type of custom setup.
 * Expected value is 'AzPowerShellSetup'.
 * @property version The required version of Azure PowerShell to install.
 */
public data class AzPowerShellSetupArgs(
    public val type: Output<String>,
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzPowerShellSetupArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzPowerShellSetupArgs =
        com.pulumi.azurenative.datafactory.inputs.AzPowerShellSetupArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzPowerShellSetupArgs].
 */
@PulumiTagMarker
public class AzPowerShellSetupArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The type of custom setup.
     * Expected value is 'AzPowerShellSetup'.
     */
    @JvmName("pehrugyfmsxktiei")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The required version of Azure PowerShell to install.
     */
    @JvmName("rgxuvtxcuqakrtvv")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The type of custom setup.
     * Expected value is 'AzPowerShellSetup'.
     */
    @JvmName("fnrnitnrartdvmjg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The required version of Azure PowerShell to install.
     */
    @JvmName("dibfqrmqtcfdhgby")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): AzPowerShellSetupArgs = AzPowerShellSetupArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
