@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.AzureStorageAuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The azure blob storage linked service.
 * @property accountKey The Azure key vault secret reference of accountKey in connection string.
 * @property accountKind Specify the kind of your storage account. Allowed values are: Storage (general purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The type used for authentication. Type: string.
 * @property azureCloudType Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property containerUri Container uri of the Azure Blob Storage resource only support for anonymous access. Type: string (or Expression with resultType string).
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property sasToken The Azure key vault secret reference of sasToken in sas uri.
 * @property sasUri SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property serviceEndpoint Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property.
 * @property servicePrincipalId The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The key of the service principal used to authenticate against Azure SQL Data Warehouse.
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureBlobStorage'.
 */
public data class AzureBlobStorageLinkedServiceArgs(
    public val accountKey: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val accountKind: Output<Any>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, AzureStorageAuthenticationType>>? = null,
    public val azureCloudType: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>? = null,
    public val containerUri: Output<Any>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val sasToken: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val sasUri: Output<Any>? = null,
    public val serviceEndpoint: Output<Any>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val tenant: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureBlobStorageLinkedServiceArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .accountKind(accountKind?.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureCloudType(azureCloudType?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .containerUri(containerUri?.applyValue({ args0 -> args0 }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .sasToken(sasToken?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sasUri(sasUri?.applyValue({ args0 -> args0 }))
            .serviceEndpoint(serviceEndpoint?.applyValue({ args0 -> args0 }))
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tenant(tenant?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBlobStorageLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureBlobStorageLinkedServiceArgsBuilder internal constructor() {
    private var accountKey: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var accountKind: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, AzureStorageAuthenticationType>>? = null

    private var azureCloudType: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var containerUri: Output<Any>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var sasToken: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var sasUri: Output<Any>? = null

    private var serviceEndpoint: Output<Any>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var tenant: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("ufquivwcgwoxkfpf")
    public suspend fun accountKey(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.accountKey = value
    }

    /**
     * @param value Specify the kind of your storage account. Allowed values are: Storage (general purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type: string (or Expression with resultType string).
     */
    @JvmName("neaguqgqunrcknhk")
    public suspend fun accountKind(`value`: Output<Any>) {
        this.accountKind = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("vcnoaxhwsjyefwbs")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("aaeqilaolxcevgiv")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("yhsamhstqmrvphds")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("wxqpidfvisdesbab")
    public suspend
    fun authenticationType(`value`: Output<Either<String, AzureStorageAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("enbaesnspvdexyoc")
    public suspend fun azureCloudType(`value`: Output<Any>) {
        this.azureCloudType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("wxitcmbspfnpuuvl")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("wmdmiyniyflebktx")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value Container uri of the Azure Blob Storage resource only support for anonymous access. Type: string (or Expression with resultType string).
     */
    @JvmName("ghnjcosjjplvpkwx")
    public suspend fun containerUri(`value`: Output<Any>) {
        this.containerUri = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("aoxtihcyovowgjvk")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("wyauwxigtxmoddkp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("wdttinmjbmqqaktc")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("rbjcucllermogbtk")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("bnfdyyxvsenjnncm")
    public suspend fun sasToken(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.sasToken = value
    }

    /**
     * @param value SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("umrqvclfvaxwdpkb")
    public suspend fun sasUri(`value`: Output<Any>) {
        this.sasUri = value
    }

    /**
     * @param value Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property.
     */
    @JvmName("ervdgebgsryonvvo")
    public suspend fun serviceEndpoint(`value`: Output<Any>) {
        this.serviceEndpoint = value
    }

    /**
     * @param value The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
     */
    @JvmName("mjqfkgcdphyaejcd")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("bjgtwrnipbpvnotx")
    public suspend
    fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("lptrxuiwjselnoxx")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureBlobStorage'.
     */
    @JvmName("rdphtilgbtqkelwj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("mbkpxcufsflncynm")
    public suspend fun accountKey(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("mhbbijsgnqeymwkb")
    public suspend
    fun accountKey(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accountKey = mapped
    }

    /**
     * @param value Specify the kind of your storage account. Allowed values are: Storage (general purpose v1), StorageV2 (general purpose v2), BlobStorage, or BlockBlobStorage. Type: string (or Expression with resultType string).
     */
    @JvmName("ahvrltavwfnfehag")
    public suspend fun accountKind(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKind = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("xdtilwyjlmmndqiq")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("rkeyegxynwiuawvg")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("mjihiycajudjjuav")
    public suspend fun authenticationType(`value`: Either<String, AzureStorageAuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("iaewykryrqcbsfer")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureStorageAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The type used for authentication. Type: string.
     */
    @JvmName("abauhqqayfgghwcp")
    public fun authenticationType(`value`: AzureStorageAuthenticationType) {
        val toBeMapped = Either.ofRight<String, AzureStorageAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("xfgalefcqcouvqwu")
    public suspend fun azureCloudType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureCloudType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("kptjlpliiecllxqe")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("cyegqhtfmnpchxav")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("wmcrceaffqrticby")
    public suspend fun connectionString(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Container uri of the Azure Blob Storage resource only support for anonymous access. Type: string (or Expression with resultType string).
     */
    @JvmName("ctewvnsbqoxydegr")
    public suspend fun containerUri(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerUri = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("kuxcecwobegowluo")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("tlvtexbakmfsydff")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("tcfnowqucjiebwth")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("vukctqrgkjboqdep")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("isgqtyoesbcprhxi")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("xwthjuvtkeljumea")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("fehpcwjyayxhumlm")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("lcfohagitmqmtdnn")
    public suspend fun sasToken(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasToken = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("dyhfqgoyjnrqrloy")
    public suspend
    fun sasToken(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sasToken = mapped
    }

    /**
     * @param value SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("jpfogjiqyimtuupw")
    public suspend fun sasUri(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasUri = mapped
    }

    /**
     * @param value Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property.
     */
    @JvmName("rqwijuviwdwydsry")
    public suspend fun serviceEndpoint(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpoint = mapped
    }

    /**
     * @param value The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
     */
    @JvmName("rxywsluqficbywkh")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("yliaavwtbkdmxrpc")
    public suspend
    fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("gprgjhimkbevuovb")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("seivhsnbefwtywim")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("sqlcqgagyfsogjgn")
    public suspend fun tenant(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureBlobStorage'.
     */
    @JvmName("afwjtgynyteoajev")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureBlobStorageLinkedServiceArgs = AzureBlobStorageLinkedServiceArgs(
        accountKey = accountKey,
        accountKind = accountKind,
        annotations = annotations,
        authenticationType = authenticationType,
        azureCloudType = azureCloudType,
        connectVia = connectVia,
        connectionString = connectionString,
        containerUri = containerUri,
        credential = credential,
        description = description,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        sasToken = sasToken,
        sasUri = sasUri,
        serviceEndpoint = serviceEndpoint,
        servicePrincipalId = servicePrincipalId,
        servicePrincipalKey = servicePrincipalKey,
        tenant = tenant,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
