@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeExportCommandArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Databricks Delta Lake export command settings.
 * @property dateFormat Specify the date format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
 * @property timestampFormat Specify the timestamp format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
 * @property type The export setting type.
 * Expected value is 'AzureDatabricksDeltaLakeExportCommand'.
 */
public data class AzureDatabricksDeltaLakeExportCommandArgs(
    public val dateFormat: Output<Any>? = null,
    public val timestampFormat: Output<Any>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeExportCommandArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeExportCommandArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeExportCommandArgs.builder()
            .dateFormat(dateFormat?.applyValue({ args0 -> args0 }))
            .timestampFormat(timestampFormat?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDatabricksDeltaLakeExportCommandArgs].
 */
@PulumiTagMarker
public class AzureDatabricksDeltaLakeExportCommandArgsBuilder internal constructor() {
    private var dateFormat: Output<Any>? = null

    private var timestampFormat: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specify the date format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
     */
    @JvmName("xsesxakmqqjaufkd")
    public suspend fun dateFormat(`value`: Output<Any>) {
        this.dateFormat = value
    }

    /**
     * @param value Specify the timestamp format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
     */
    @JvmName("eftpvncptaccyfgh")
    public suspend fun timestampFormat(`value`: Output<Any>) {
        this.timestampFormat = value
    }

    /**
     * @param value The export setting type.
     * Expected value is 'AzureDatabricksDeltaLakeExportCommand'.
     */
    @JvmName("uflntamdqwremjtf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specify the date format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
     */
    @JvmName("rqfhsintcpxwldxk")
    public suspend fun dateFormat(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateFormat = mapped
    }

    /**
     * @param value Specify the timestamp format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
     */
    @JvmName("yjbnfbwugmbfaukd")
    public suspend fun timestampFormat(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestampFormat = mapped
    }

    /**
     * @param value The export setting type.
     * Expected value is 'AzureDatabricksDeltaLakeExportCommand'.
     */
    @JvmName("lkxfxpuohxuddohd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureDatabricksDeltaLakeExportCommandArgs =
        AzureDatabricksDeltaLakeExportCommandArgs(
            dateFormat = dateFormat,
            timestampFormat = timestampFormat,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
