@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity Azure Databricks Delta Lake source.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property exportSettings Azure Databricks Delta Lake export settings.
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property query Azure Databricks Delta Lake Sql query. Type: string (or Expression with resultType string).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'AzureDatabricksDeltaLakeSource'.
 */
public data class AzureDatabricksDeltaLakeSourceArgs(
    public val disableMetricsCollection: Output<Any>? = null,
    public val exportSettings: Output<AzureDatabricksDeltaLakeExportCommandArgs>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val query: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeSourceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeSourceArgs.builder()
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .exportSettings(exportSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDatabricksDeltaLakeSourceArgs].
 */
@PulumiTagMarker
public class AzureDatabricksDeltaLakeSourceArgsBuilder internal constructor() {
    private var disableMetricsCollection: Output<Any>? = null

    private var exportSettings: Output<AzureDatabricksDeltaLakeExportCommandArgs>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var query: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("rfwicmdwlewdamls")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Azure Databricks Delta Lake export settings.
     */
    @JvmName("foxjbscalpdyxppn")
    public suspend fun exportSettings(`value`: Output<AzureDatabricksDeltaLakeExportCommandArgs>) {
        this.exportSettings = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("eyigrybxweflmnop")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Azure Databricks Delta Lake Sql query. Type: string (or Expression with resultType string).
     */
    @JvmName("prtnfxgtbhwofvrg")
    public suspend fun query(`value`: Output<Any>) {
        this.query = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("gxyellkxctudpqbw")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("jteuvjmvibvamneg")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'AzureDatabricksDeltaLakeSource'.
     */
    @JvmName("udelfdgritrgceig")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("sktkhoyttrbybigc")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Azure Databricks Delta Lake export settings.
     */
    @JvmName("mwbnglcwcbxcgskv")
    public suspend fun exportSettings(`value`: AzureDatabricksDeltaLakeExportCommandArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportSettings = mapped
    }

    /**
     * @param argument Azure Databricks Delta Lake export settings.
     */
    @JvmName("wlgrhpfjqheoulvu")
    public suspend
    fun exportSettings(argument: suspend AzureDatabricksDeltaLakeExportCommandArgsBuilder.() -> Unit) {
        val toBeMapped = AzureDatabricksDeltaLakeExportCommandArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.exportSettings = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("qdfoqspavkraytrh")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Azure Databricks Delta Lake Sql query. Type: string (or Expression with resultType string).
     */
    @JvmName("ngumnmsgsbqeqycs")
    public suspend fun query(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("avaipdluxvqyqbqy")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("gobcflkyqkpdcims")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'AzureDatabricksDeltaLakeSource'.
     */
    @JvmName("idiuymeixsvvembl")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureDatabricksDeltaLakeSourceArgs = AzureDatabricksDeltaLakeSourceArgs(
        disableMetricsCollection = disableMetricsCollection,
        exportSettings = exportSettings,
        maxConcurrentConnections = maxConcurrentConnections,
        query = query,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
