@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureFileStorageLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure File Storage linked service.
 * @property accountKey The Azure key vault secret reference of accountKey in connection string.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property fileShare The azure file share name. It is required when auth with accountKey/sasToken. Type: string (or Expression with resultType string).
 * @property host Host name of the server. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property password Password to logon the server.
 * @property sasToken The Azure key vault secret reference of sasToken in sas uri.
 * @property sasUri SAS URI of the Azure File resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property snapshot The azure file share snapshot version. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureFileStorage'.
 * @property userId User ID to logon the server. Type: string (or Expression with resultType string).
 */
public data class AzureFileStorageLinkedServiceArgs(
    public val accountKey: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val fileShare: Output<Any>? = null,
    public val host: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val sasToken: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val sasUri: Output<Any>? = null,
    public val snapshot: Output<Any>? = null,
    public val type: Output<String>,
    public val userId: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureFileStorageLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureFileStorageLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureFileStorageLinkedServiceArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .fileShare(fileShare?.applyValue({ args0 -> args0 }))
            .host(host?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sasToken(sasToken?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sasUri(sasUri?.applyValue({ args0 -> args0 }))
            .snapshot(snapshot?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFileStorageLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureFileStorageLinkedServiceArgsBuilder internal constructor() {
    private var accountKey: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var fileShare: Output<Any>? = null

    private var host: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var sasToken: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var sasUri: Output<Any>? = null

    private var snapshot: Output<Any>? = null

    private var type: Output<String>? = null

    private var userId: Output<Any>? = null

    /**
     * @param value The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("linndvnditjibudu")
    public suspend fun accountKey(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.accountKey = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("lnpcuyvkbiulnfca")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("hakssyrevrntyxhf")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("wmgkjmnijiuvqnhv")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("tlvmrprcdccoesva")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("lwfrnlechdqaxyvo")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("iiynvnywlhclofxl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("mhxlwnvpipuotusb")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The azure file share name. It is required when auth with accountKey/sasToken. Type: string (or Expression with resultType string).
     */
    @JvmName("ehyexjcqoybnvwth")
    public suspend fun fileShare(`value`: Output<Any>) {
        this.fileShare = value
    }

    /**
     * @param value Host name of the server. Type: string (or Expression with resultType string).
     */
    @JvmName("pnymqlgqllxmojad")
    public suspend fun host(`value`: Output<Any>) {
        this.host = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("rkskptxptkyuxelj")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Password to logon the server.
     */
    @JvmName("cwyamdphyjbucdbh")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("kihupblbubqqcpfx")
    public suspend fun sasToken(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.sasToken = value
    }

    /**
     * @param value SAS URI of the Azure File resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("jceefnfvcgjpfwxd")
    public suspend fun sasUri(`value`: Output<Any>) {
        this.sasUri = value
    }

    /**
     * @param value The azure file share snapshot version. Type: string (or Expression with resultType string).
     */
    @JvmName("cunxxllpfabccqcv")
    public suspend fun snapshot(`value`: Output<Any>) {
        this.snapshot = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureFileStorage'.
     */
    @JvmName("hpaahchnytvisndt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value User ID to logon the server. Type: string (or Expression with resultType string).
     */
    @JvmName("mapxrlurtcplowdj")
    public suspend fun userId(`value`: Output<Any>) {
        this.userId = value
    }

    /**
     * @param value The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("hxmqkfjrwismcuvq")
    public suspend fun accountKey(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("faqbvdnaxxaohxtv")
    public suspend
    fun accountKey(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accountKey = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("abqpbsrcopyxpphb")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("dhcdmtkyoxeuwyyk")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("iuprjeiivqnsyoyg")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("spcprspbwxyfgcwk")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("nuulugxdubtsnmhq")
    public suspend fun connectionString(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("cpvafheblxtklyng")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("lvnbhcrbqgmigdur")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The azure file share name. It is required when auth with accountKey/sasToken. Type: string (or Expression with resultType string).
     */
    @JvmName("ccsayousteifonoo")
    public suspend fun fileShare(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileShare = mapped
    }

    /**
     * @param value Host name of the server. Type: string (or Expression with resultType string).
     */
    @JvmName("yjottglqwfymkatf")
    public suspend fun host(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("fjrrqlbteegcmlgv")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("flpycgiqjmaaoycp")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("ithkrpnsolmnywxu")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Password to logon the server.
     */
    @JvmName("fbsocjiogucueolv")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password to logon the server.
     */
    @JvmName("jopbiooymemttouc")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password to logon the server.
     */
    @JvmName("krnfhqeajsfhyqwt")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("gvsluryibsnpyafl")
    public suspend fun sasToken(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasToken = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("mpdcvumlclvaowur")
    public suspend
    fun sasToken(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sasToken = mapped
    }

    /**
     * @param value SAS URI of the Azure File resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("qydelkwkgfnnefsl")
    public suspend fun sasUri(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasUri = mapped
    }

    /**
     * @param value The azure file share snapshot version. Type: string (or Expression with resultType string).
     */
    @JvmName("qvtmfgalemjordba")
    public suspend fun snapshot(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshot = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureFileStorage'.
     */
    @JvmName("bheveqiyovdoiimt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value User ID to logon the server. Type: string (or Expression with resultType string).
     */
    @JvmName("htmxkungexagveum")
    public suspend fun userId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): AzureFileStorageLinkedServiceArgs = AzureFileStorageLinkedServiceArgs(
        accountKey = accountKey,
        annotations = annotations,
        connectVia = connectVia,
        connectionString = connectionString,
        description = description,
        encryptedCredential = encryptedCredential,
        fileShare = fileShare,
        host = host,
        parameters = parameters,
        password = password,
        sasToken = sasToken,
        sasUri = sasUri,
        snapshot = snapshot,
        type = type ?: throw PulumiNullFieldException("type"),
        userId = userId,
    )
}
