@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureTableStorageLinkedServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The azure table storage linked service.
 * @property accountKey The Azure key vault secret reference of accountKey in connection string.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property sasToken The Azure key vault secret reference of sasToken in sas uri.
 * @property sasUri SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property type Type of linked service.
 * Expected value is 'AzureTableStorage'.
 */
public data class AzureTableStorageLinkedServiceArgs(
    public val accountKey: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val sasToken: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val sasUri: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureTableStorageLinkedServiceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AzureTableStorageLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureTableStorageLinkedServiceArgs.builder()
            .accountKey(accountKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .sasToken(sasToken?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sasUri(sasUri?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureTableStorageLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureTableStorageLinkedServiceArgsBuilder internal constructor() {
    private var accountKey: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var sasToken: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var sasUri: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("psspdpdkcfxbloeq")
    public suspend fun accountKey(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.accountKey = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("awlbiijioygmstvr")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("csyhujbesikdjefo")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("mrikvtkealqnonlp")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("kaujoatvlrahqsoi")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("rdursrpfsiafhnss")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("qommfkolbyvwcyli")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("renlwuaotlpecqnl")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ycydlcbiejrxngsn")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("ypbsskrjdxnbctji")
    public suspend fun sasToken(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.sasToken = value
    }

    /**
     * @param value SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("rkuajrahfpgvhoqp")
    public suspend fun sasUri(`value`: Output<Any>) {
        this.sasUri = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureTableStorage'.
     */
    @JvmName("gerqstrjhbncswnx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("cmujdwvajwvrtcsi")
    public suspend fun accountKey(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of accountKey in connection string.
     */
    @JvmName("bkgbrkglluqcxeum")
    public suspend
    fun accountKey(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accountKey = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("xtlcahbmlmxdrcdt")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("dxcxevhiuoqjmxoe")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("bfjhoesethxwuuvs")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("jwgaieukebebcino")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("lpriraralloqbmix")
    public suspend fun connectionString(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("fkmfwnqdrncqhiyv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("lkakdhkkgslnkswt")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("awyhulbtwgsgyfil")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("pfjldjuprfuuqquq")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("jrgilkmbeguceeup")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("aigayptripfudyjm")
    public suspend fun sasToken(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasToken = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of sasToken in sas uri.
     */
    @JvmName("ekicipckwkhfchfo")
    public suspend
    fun sasToken(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sasToken = mapped
    }

    /**
     * @param value SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("xrebgenflviveusw")
    public suspend fun sasUri(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasUri = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureTableStorage'.
     */
    @JvmName("yihuybxfbdiibovr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureTableStorageLinkedServiceArgs = AzureTableStorageLinkedServiceArgs(
        accountKey = accountKey,
        annotations = annotations,
        connectVia = connectVia,
        connectionString = connectionString,
        description = description,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        sasToken = sasToken,
        sasUri = sasUri,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
