@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.BlobSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A copy activity Azure Blob sink.
 * @property blobWriterAddHeader Blob writer add header. Type: boolean (or Expression with resultType boolean).
 * @property blobWriterDateTimeFormat Blob writer date time format. Type: string (or Expression with resultType string).
 * @property blobWriterOverwriteFiles Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
 * @property copyBehavior The type of copy behavior for copy sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property metadata Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'BlobSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 */
public data class BlobSinkArgs(
    public val blobWriterAddHeader: Output<Any>? = null,
    public val blobWriterDateTimeFormat: Output<Any>? = null,
    public val blobWriterOverwriteFiles: Output<Any>? = null,
    public val copyBehavior: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val metadata: Output<List<MetadataItemArgs>>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val type: Output<String>,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.BlobSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.BlobSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.BlobSinkArgs.builder()
            .blobWriterAddHeader(blobWriterAddHeader?.applyValue({ args0 -> args0 }))
            .blobWriterDateTimeFormat(blobWriterDateTimeFormat?.applyValue({ args0 -> args0 }))
            .blobWriterOverwriteFiles(blobWriterOverwriteFiles?.applyValue({ args0 -> args0 }))
            .copyBehavior(copyBehavior?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobSinkArgs].
 */
@PulumiTagMarker
public class BlobSinkArgsBuilder internal constructor() {
    private var blobWriterAddHeader: Output<Any>? = null

    private var blobWriterDateTimeFormat: Output<Any>? = null

    private var blobWriterOverwriteFiles: Output<Any>? = null

    private var copyBehavior: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var metadata: Output<List<MetadataItemArgs>>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    /**
     * @param value Blob writer add header. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("wnbcaljqjawtujkx")
    public suspend fun blobWriterAddHeader(`value`: Output<Any>) {
        this.blobWriterAddHeader = value
    }

    /**
     * @param value Blob writer date time format. Type: string (or Expression with resultType string).
     */
    @JvmName("uuhvtsjtpvfnymcl")
    public suspend fun blobWriterDateTimeFormat(`value`: Output<Any>) {
        this.blobWriterDateTimeFormat = value
    }

    /**
     * @param value Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("qjqnldeiryinnqbt")
    public suspend fun blobWriterOverwriteFiles(`value`: Output<Any>) {
        this.blobWriterOverwriteFiles = value
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("ylamwohndnhvxsob")
    public suspend fun copyBehavior(`value`: Output<Any>) {
        this.copyBehavior = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("nvrknpduwsgghsyc")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("pdmprcmixvhmecqn")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("aqnvmoyvvpibmame")
    public suspend fun metadata(`value`: Output<List<MetadataItemArgs>>) {
        this.metadata = value
    }

    @JvmName("oyewmyuiocyxyyhg")
    public suspend fun metadata(vararg values: Output<MetadataItemArgs>) {
        this.metadata = Output.all(values.asList())
    }

    /**
     * @param values Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("crnbcvjyxxayedxd")
    public suspend fun metadata(values: List<Output<MetadataItemArgs>>) {
        this.metadata = Output.all(values)
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("devdevufanesmqjp")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("khdploetiygpvnav")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'BlobSink'.
     */
    @JvmName("kvadsqcixosytqot")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("jlvpbhthaeqboxvb")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("qvhkhanwgokabcen")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value Blob writer add header. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("xvwuejsikmgipaao")
    public suspend fun blobWriterAddHeader(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobWriterAddHeader = mapped
    }

    /**
     * @param value Blob writer date time format. Type: string (or Expression with resultType string).
     */
    @JvmName("mblcklqiqigepweq")
    public suspend fun blobWriterDateTimeFormat(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobWriterDateTimeFormat = mapped
    }

    /**
     * @param value Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("agyyxbrvaeelwirj")
    public suspend fun blobWriterOverwriteFiles(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobWriterOverwriteFiles = mapped
    }

    /**
     * @param value The type of copy behavior for copy sink.
     */
    @JvmName("xhikmfpfjhqjjswu")
    public suspend fun copyBehavior(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyBehavior = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("yljybedfhflnlsxc")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("lwuanlcqwavmntvf")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("udjhnfkqbqxqvptt")
    public suspend fun metadata(`value`: List<MetadataItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("knjdeidjghubtdnp")
    public suspend fun metadata(argument: List<suspend MetadataItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("bhngtjkgpypwjsoa")
    public suspend fun metadata(vararg argument: suspend MetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MetadataItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param argument Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("owiyeqtwafmvkqxt")
    public suspend fun metadata(argument: suspend MetadataItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetadataItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metadata = mapped
    }

    /**
     * @param values Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
     */
    @JvmName("jytediaxvietewgq")
    public suspend fun metadata(vararg values: MetadataItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("evbffqhdwmfqscuh")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("bmxhnohenngcwptm")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'BlobSink'.
     */
    @JvmName("rsmohbobxvmvyfwk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("uehdptoaojongybf")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("mwxrgnacilceqogl")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    internal fun build(): BlobSinkArgs = BlobSinkArgs(
        blobWriterAddHeader = blobWriterAddHeader,
        blobWriterDateTimeFormat = blobWriterDateTimeFormat,
        blobWriterOverwriteFiles = blobWriterOverwriteFiles,
        copyBehavior = copyBehavior,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        metadata = metadata,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
    )
}
