@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CommonDataServiceForAppsSinkArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.DynamicsSinkWriteBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity Common Data Service for Apps sink.
 * @property alternateKeyName The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property ignoreNullValues The flag indicating whether to ignore null values from input dataset (except key fields) during write operation. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'CommonDataServiceForAppsSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property writeBehavior The write behavior for the operation.
 */
public data class CommonDataServiceForAppsSinkArgs(
    public val alternateKeyName: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val ignoreNullValues: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val type: Output<String>,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
    public val writeBehavior: Output<Either<String, DynamicsSinkWriteBehavior>>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CommonDataServiceForAppsSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CommonDataServiceForAppsSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.CommonDataServiceForAppsSinkArgs.builder()
            .alternateKeyName(alternateKeyName?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .ignoreNullValues(ignoreNullValues?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 }))
            .writeBehavior(
                writeBehavior.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CommonDataServiceForAppsSinkArgs].
 */
@PulumiTagMarker
public class CommonDataServiceForAppsSinkArgsBuilder internal constructor() {
    private var alternateKeyName: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var ignoreNullValues: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    private var writeBehavior: Output<Either<String, DynamicsSinkWriteBehavior>>? = null

    /**
     * @param value The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType string).
     */
    @JvmName("prtalhlxlkuxhnog")
    public suspend fun alternateKeyName(`value`: Output<Any>) {
        this.alternateKeyName = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("bmibssnoxlcusabg")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The flag indicating whether to ignore null values from input dataset (except key fields) during write operation. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("rvafcjimkhelucws")
    public suspend fun ignoreNullValues(`value`: Output<Any>) {
        this.ignoreNullValues = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("kymdbtrpfaijvpft")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("dvadwtqsxavjudmy")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("rqegdcqwsvfrartp")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'CommonDataServiceForAppsSink'.
     */
    @JvmName("vfsxfgrkyeqxgnya")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("titbrhhfujevlxac")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("spukbbgeoigsbjui")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value The write behavior for the operation.
     */
    @JvmName("gjuwmnsortfumqur")
    public suspend fun writeBehavior(`value`: Output<Either<String, DynamicsSinkWriteBehavior>>) {
        this.writeBehavior = value
    }

    /**
     * @param value The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType string).
     */
    @JvmName("dlkifgjrkmfhvkac")
    public suspend fun alternateKeyName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternateKeyName = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("uxfywmdveexibynu")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The flag indicating whether to ignore null values from input dataset (except key fields) during write operation. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("thdinsnrpmfhseqp")
    public suspend fun ignoreNullValues(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreNullValues = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("srfmtdhpkedhcglt")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("noqayfewabxfetmw")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("ostfewucdfargryg")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'CommonDataServiceForAppsSink'.
     */
    @JvmName("eccgvgrjmqfqgiun")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("mbflhqqstrxhrabh")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("jwocyxwiesjowmfc")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    /**
     * @param value The write behavior for the operation.
     */
    @JvmName("kulbvssejgodfsdb")
    public suspend fun writeBehavior(`value`: Either<String, DynamicsSinkWriteBehavior>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    /**
     * @param value The write behavior for the operation.
     */
    @JvmName("fvaaopmkrlctutka")
    public fun writeBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DynamicsSinkWriteBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    /**
     * @param value The write behavior for the operation.
     */
    @JvmName("jkfhmshmrnahvrmo")
    public fun writeBehavior(`value`: DynamicsSinkWriteBehavior) {
        val toBeMapped = Either.ofRight<String, DynamicsSinkWriteBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.writeBehavior = mapped
    }

    internal fun build(): CommonDataServiceForAppsSinkArgs = CommonDataServiceForAppsSinkArgs(
        alternateKeyName = alternateKeyName,
        disableMetricsCollection = disableMetricsCollection,
        ignoreNullValues = ignoreNullValues,
        maxConcurrentConnections = maxConcurrentConnections,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
        writeBehavior = writeBehavior ?: throw PulumiNullFieldException("writeBehavior"),
    )
}
