@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CopyActivityLogSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings for copy activity log.
 * @property enableReliableLogging Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
 * @property logLevel Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
 */
public data class CopyActivityLogSettingsArgs(
    public val enableReliableLogging: Output<Any>? = null,
    public val logLevel: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CopyActivityLogSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CopyActivityLogSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.CopyActivityLogSettingsArgs.builder()
            .enableReliableLogging(enableReliableLogging?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CopyActivityLogSettingsArgs].
 */
@PulumiTagMarker
public class CopyActivityLogSettingsArgsBuilder internal constructor() {
    private var enableReliableLogging: Output<Any>? = null

    private var logLevel: Output<Any>? = null

    /**
     * @param value Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("psqpcyuioggrcpbt")
    public suspend fun enableReliableLogging(`value`: Output<Any>) {
        this.enableReliableLogging = value
    }

    /**
     * @param value Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
     */
    @JvmName("mmsoxhcgviofpiny")
    public suspend fun logLevel(`value`: Output<Any>) {
        this.logLevel = value
    }

    /**
     * @param value Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ijxxoersmipwsupm")
    public suspend fun enableReliableLogging(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableReliableLogging = mapped
    }

    /**
     * @param value Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
     */
    @JvmName("pahtkftjbnwiksto")
    public suspend fun logLevel(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    internal fun build(): CopyActivityLogSettingsArgs = CopyActivityLogSettingsArgs(
        enableReliableLogging = enableReliableLogging,
        logLevel = logLevel,
    )
}
