@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CosmosDbLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.CosmosDbConnectionMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Microsoft Azure Cosmos Database (CosmosDB) linked service.
 * @property accountEndpoint The endpoint of the Azure CosmosDB account. Type: string (or Expression with resultType string)
 * @property accountKey The account key of the Azure CosmosDB account. Type: SecureString or AzureKeyVaultSecretReference.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property azureCloudType Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property connectionMode The connection mode used to access CosmosDB account. Type: string.
 * @property connectionString The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property credential The credential reference containing authentication information.
 * @property database The name of the database. Type: string (or Expression with resultType string)
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property servicePrincipalCredential The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
 * @property servicePrincipalCredentialType The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string.
 * @property servicePrincipalId The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string).
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'CosmosDb'.
 */
public data class CosmosDbLinkedServiceArgs(
    public val accountEndpoint: Output<Any>? = null,
    public val accountKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val azureCloudType: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionMode: Output<Either<String, CosmosDbConnectionMode>>? = null,
    public val connectionString: Output<Any>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val database: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val servicePrincipalCredential:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val servicePrincipalCredentialType: Output<Any>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val tenant: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CosmosDbLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CosmosDbLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.CosmosDbLinkedServiceArgs.builder()
            .accountEndpoint(accountEndpoint?.applyValue({ args0 -> args0 }))
            .accountKey(
                accountKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .azureCloudType(azureCloudType?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionMode(
                connectionMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .database(database?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .servicePrincipalCredential(
                servicePrincipalCredential?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0.let({ args0 -> args0.toJava() }) }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .servicePrincipalCredentialType(servicePrincipalCredentialType?.applyValue({ args0 -> args0 }))
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .tenant(tenant?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CosmosDbLinkedServiceArgs].
 */
@PulumiTagMarker
public class CosmosDbLinkedServiceArgsBuilder internal constructor() {
    private var accountEndpoint: Output<Any>? = null

    private var accountKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var annotations: Output<List<Any>>? = null

    private var azureCloudType: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionMode: Output<Either<String, CosmosDbConnectionMode>>? = null

    private var connectionString: Output<Any>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var database: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var servicePrincipalCredential:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var servicePrincipalCredentialType: Output<Any>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var tenant: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The endpoint of the Azure CosmosDB account. Type: string (or Expression with resultType string)
     */
    @JvmName("irdeqxufqfkbocve")
    public suspend fun accountEndpoint(`value`: Output<Any>) {
        this.accountEndpoint = value
    }

    /**
     * @param value The account key of the Azure CosmosDB account. Type: SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("ydoogwwlwlxqymjw")
    public suspend
    fun accountKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.accountKey = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("hwqwwipbecadbobe")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("movbmodbrqqyankm")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("pxbiuaumhcbmrchr")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("xmnbqrpholvbrujb")
    public suspend fun azureCloudType(`value`: Output<Any>) {
        this.azureCloudType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("nbtrgowcfaxjhoec")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The connection mode used to access CosmosDB account. Type: string.
     */
    @JvmName("xythclhtjvqlccto")
    public suspend fun connectionMode(`value`: Output<Either<String, CosmosDbConnectionMode>>) {
        this.connectionMode = value
    }

    /**
     * @param value The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("yuldxymynhvtrnmu")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("ytarxwvdnfkgnaqe")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value The name of the database. Type: string (or Expression with resultType string)
     */
    @JvmName("tksowekhaitsajeb")
    public suspend fun database(`value`: Output<Any>) {
        this.database = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("grneqqrlahxwknlv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("bcurikeqvyqjnxyk")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("snuvpakuejjsjcyq")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("ypldvwdeybxvqerj")
    public suspend
    fun servicePrincipalCredential(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalCredential = value
    }

    /**
     * @param value The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string.
     */
    @JvmName("hasusjbhcaluxtjd")
    public suspend fun servicePrincipalCredentialType(`value`: Output<Any>) {
        this.servicePrincipalCredentialType = value
    }

    /**
     * @param value The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("jthaxblmfcdfoptp")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("cuxglgbbjjrfodbm")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'CosmosDb'.
     */
    @JvmName("pwfeejcdqqkbrrur")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The endpoint of the Azure CosmosDB account. Type: string (or Expression with resultType string)
     */
    @JvmName("armyoikufpybrvoe")
    public suspend fun accountEndpoint(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountEndpoint = mapped
    }

    /**
     * @param value The account key of the Azure CosmosDB account. Type: SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("awuvvrchurvhequk")
    public suspend
    fun accountKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value The account key of the Azure CosmosDB account. Type: SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("xysvrmiwaosvkxba")
    public fun accountKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value The account key of the Azure CosmosDB account. Type: SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("nsuwrwqrptvobjrj")
    public fun accountKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("gbsckturwwhievjo")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("tyynpivusrerjott")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("wtukhdpclokermna")
    public suspend fun azureCloudType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureCloudType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("oqgdqncokugkxoul")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("lxfhpbqksbeldsom")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The connection mode used to access CosmosDB account. Type: string.
     */
    @JvmName("dhaibimktrvnedbm")
    public suspend fun connectionMode(`value`: Either<String, CosmosDbConnectionMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value The connection mode used to access CosmosDB account. Type: string.
     */
    @JvmName("eanoivatqxunfosq")
    public fun connectionMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CosmosDbConnectionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value The connection mode used to access CosmosDB account. Type: string.
     */
    @JvmName("hphsltpmvvlfkmts")
    public fun connectionMode(`value`: CosmosDbConnectionMode) {
        val toBeMapped = Either.ofRight<String, CosmosDbConnectionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionMode = mapped
    }

    /**
     * @param value The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("ddaufoskghqmuswo")
    public suspend fun connectionString(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("nvaoegvyskrfdwbk")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("ahvpkbeqbwtjftcw")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value The name of the database. Type: string (or Expression with resultType string)
     */
    @JvmName("cqbqewmphgadgses")
    public suspend fun database(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("lkakoalfoauqtume")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("mlnmcoqpersjmsnm")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("ebyoudeglnapbldc")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("fnxpjlsscbnhxvnc")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("tpksysfcenglssoo")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("jssctrmogqbihdqh")
    public suspend
    fun servicePrincipalCredential(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("xuxijpdfyyaulqhw")
    public fun servicePrincipalCredential(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey', servicePrincipalCredential can be SecureString or AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can only be AzureKeyVaultSecretReference.
     */
    @JvmName("omocnjfokivubsed")
    public fun servicePrincipalCredential(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalCredential = mapped
    }

    /**
     * @param value The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string.
     */
    @JvmName("tcjhxaqmkrbtfxrx")
    public suspend fun servicePrincipalCredentialType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalCredentialType = mapped
    }

    /**
     * @param value The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression with resultType string).
     */
    @JvmName("bqsxvjeuwbbhgjvs")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("wcetcwibbktriwdv")
    public suspend fun tenant(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'CosmosDb'.
     */
    @JvmName("ilupregmqgbxfuuw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CosmosDbLinkedServiceArgs = CosmosDbLinkedServiceArgs(
        accountEndpoint = accountEndpoint,
        accountKey = accountKey,
        annotations = annotations,
        azureCloudType = azureCloudType,
        connectVia = connectVia,
        connectionMode = connectionMode,
        connectionString = connectionString,
        credential = credential,
        database = database,
        description = description,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        servicePrincipalCredential = servicePrincipalCredential,
        servicePrincipalCredentialType = servicePrincipalCredentialType,
        servicePrincipalId = servicePrincipalId,
        tenant = tenant,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
