@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DataFlowStagingInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Staging info for execute data flow activity.
 * @property folderPath Folder path for staging blob. Type: string (or Expression with resultType string)
 * @property linkedService Staging linked service reference.
 */
public data class DataFlowStagingInfoArgs(
    public val folderPath: Output<Any>? = null,
    public val linkedService: Output<LinkedServiceReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DataFlowStagingInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DataFlowStagingInfoArgs =
        com.pulumi.azurenative.datafactory.inputs.DataFlowStagingInfoArgs.builder()
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .linkedService(linkedService?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataFlowStagingInfoArgs].
 */
@PulumiTagMarker
public class DataFlowStagingInfoArgsBuilder internal constructor() {
    private var folderPath: Output<Any>? = null

    private var linkedService: Output<LinkedServiceReferenceArgs>? = null

    /**
     * @param value Folder path for staging blob. Type: string (or Expression with resultType string)
     */
    @JvmName("huwrtnaccevyanoo")
    public suspend fun folderPath(`value`: Output<Any>) {
        this.folderPath = value
    }

    /**
     * @param value Staging linked service reference.
     */
    @JvmName("pelhtpyuflvlcuma")
    public suspend fun linkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedService = value
    }

    /**
     * @param value Folder path for staging blob. Type: string (or Expression with resultType string)
     */
    @JvmName("barsiuqapmsiyovh")
    public suspend fun folderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value Staging linked service reference.
     */
    @JvmName("onbybnfxypopfhrt")
    public suspend fun linkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedService = mapped
    }

    /**
     * @param argument Staging linked service reference.
     */
    @JvmName("asgkygjncwmxxjpr")
    public suspend fun linkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedService = mapped
    }

    internal fun build(): DataFlowStagingInfoArgs = DataFlowStagingInfoArgs(
        folderPath = folderPath,
        linkedService = linkedService,
    )
}
