@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.Db2LinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.Db2AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for DB2 data source.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType AuthenticationType to be used for connection. It is mutually exclusive with connectionString property.
 * @property certificateCommonName Certificate Common Name when TLS is enabled. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. It is mutually exclusive with server, database, authenticationType, userName, packageCollection and certificateCommonName property. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property database Database name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. It is mutually exclusive with connectionString property. Type: string.
 * @property packageCollection Under where packages are created when querying database. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property password Password for authentication.
 * @property server Server name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'Db2'.
 * @property username Username for authentication. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
 */
public data class Db2LinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, Db2AuthenticationType>>? = null,
    public val certificateCommonName: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>? = null,
    public val database: Output<Any>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val packageCollection: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val server: Output<Any>? = null,
    public val type: Output<String>,
    public val username: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.Db2LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.Db2LinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.Db2LinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .certificateCommonName(certificateCommonName?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .database(database?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .packageCollection(packageCollection?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .server(server?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [Db2LinkedServiceArgs].
 */
@PulumiTagMarker
public class Db2LinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, Db2AuthenticationType>>? = null

    private var certificateCommonName: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var database: Output<Any>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var packageCollection: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var server: Output<Any>? = null

    private var type: Output<String>? = null

    private var username: Output<Any>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("fukeihiaarhyiqwe")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ddtuuoymibypobur")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("toeooukbhglcxpoe")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value AuthenticationType to be used for connection. It is mutually exclusive with connectionString property.
     */
    @JvmName("eduvqufvkydbhgnw")
    public suspend fun authenticationType(`value`: Output<Either<String, Db2AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value Certificate Common Name when TLS is enabled. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JvmName("rsqgxvbmqjfhqrha")
    public suspend fun certificateCommonName(`value`: Output<Any>) {
        this.certificateCommonName = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("dqnrtjltlykscxfd")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The connection string. It is mutually exclusive with server, database, authenticationType, userName, packageCollection and certificateCommonName property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("cyrvmppxpmsqbqbc")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value Database name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JvmName("rmbexxtlcnlnclgl")
    public suspend fun database(`value`: Output<Any>) {
        this.database = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("yqtlhdsusfljrmbw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. It is mutually exclusive with connectionString property. Type: string.
     */
    @JvmName("cwxxjmqewxynowig")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Under where packages are created when querying database. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JvmName("bibsshvdvfgjhhhr")
    public suspend fun packageCollection(`value`: Output<Any>) {
        this.packageCollection = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("uoleaifyjnmdjmlv")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("dhdpmyclmorsuntf")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value Server name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JvmName("bojxpbuqbnasrada")
    public suspend fun server(`value`: Output<Any>) {
        this.server = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Db2'.
     */
    @JvmName("cafcnqasrrugjqem")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Username for authentication. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JvmName("eistkilsfncjffwp")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("mrlwpmiaejanakuf")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("hyaaxnvufuoilynh")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value AuthenticationType to be used for connection. It is mutually exclusive with connectionString property.
     */
    @JvmName("moirnytcitfgdwda")
    public suspend fun authenticationType(`value`: Either<String, Db2AuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value AuthenticationType to be used for connection. It is mutually exclusive with connectionString property.
     */
    @JvmName("rmibmxqprrfqpwlb")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Db2AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value AuthenticationType to be used for connection. It is mutually exclusive with connectionString property.
     */
    @JvmName("ecmkmegwkdwxrfdq")
    public fun authenticationType(`value`: Db2AuthenticationType) {
        val toBeMapped = Either.ofRight<String, Db2AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Certificate Common Name when TLS is enabled. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JvmName("acywwvmcdlkabehy")
    public suspend fun certificateCommonName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateCommonName = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("fsqdlvsfpbjfehlv")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("psvexplnvwabmagb")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The connection string. It is mutually exclusive with server, database, authenticationType, userName, packageCollection and certificateCommonName property. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("jehxbgbxxmffecih")
    public suspend fun connectionString(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value Database name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JvmName("nwwfkwjlepvnjpnm")
    public suspend fun database(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("smrnpwyeubokgnmv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. It is mutually exclusive with connectionString property. Type: string.
     */
    @JvmName("nlwrnqrcycqdbvyk")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Under where packages are created when querying database. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JvmName("bqhqgrolrwsilisc")
    public suspend fun packageCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageCollection = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("iijnbdygtvgnywjb")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("gckhevpivptocyiy")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("rmcsdbmsomicnlqa")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("fmpweuvnupiwokow")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("cvwaonuxmtmrladl")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Password for authentication.
     */
    @JvmName("tryjecdhvhldywll")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Server name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JvmName("xasrlqkvtqnpwvii")
    public suspend fun server(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Db2'.
     */
    @JvmName("xwetqflfctkyhilw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Username for authentication. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType string).
     */
    @JvmName("kdoumdhuqvxmikru")
    public suspend fun username(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): Db2LinkedServiceArgs = Db2LinkedServiceArgs(
        annotations = annotations,
        authenticationType = authenticationType,
        certificateCommonName = certificateCommonName,
        connectVia = connectVia,
        connectionString = connectionString,
        database = database,
        description = description,
        encryptedCredential = encryptedCredential,
        packageCollection = packageCollection,
        parameters = parameters,
        password = password,
        server = server,
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
