@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.EntityReferenceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.IntegrationRuntimeEntityReferenceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The entity reference.
 * @property referenceName The name of this referenced entity.
 * @property type The type of this referenced entity.
 */
public data class EntityReferenceArgs(
    public val referenceName: Output<String>? = null,
    public val type: Output<Either<String, IntegrationRuntimeEntityReferenceType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.EntityReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.EntityReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.EntityReferenceArgs.builder()
            .referenceName(referenceName?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EntityReferenceArgs].
 */
@PulumiTagMarker
public class EntityReferenceArgsBuilder internal constructor() {
    private var referenceName: Output<String>? = null

    private var type: Output<Either<String, IntegrationRuntimeEntityReferenceType>>? = null

    /**
     * @param value The name of this referenced entity.
     */
    @JvmName("jusedalynmkvfqkj")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value The type of this referenced entity.
     */
    @JvmName("jtkxdpbweuolscua")
    public suspend fun type(`value`: Output<Either<String, IntegrationRuntimeEntityReferenceType>>) {
        this.type = value
    }

    /**
     * @param value The name of this referenced entity.
     */
    @JvmName("cvxcuepcdwjoriqx")
    public suspend fun referenceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value The type of this referenced entity.
     */
    @JvmName("xedelmgliapclkkl")
    public suspend fun type(`value`: Either<String, IntegrationRuntimeEntityReferenceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of this referenced entity.
     */
    @JvmName("atvbeahxpjrhjtpa")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntegrationRuntimeEntityReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of this referenced entity.
     */
    @JvmName("mqfukejuwqaskcaf")
    public fun type(`value`: IntegrationRuntimeEntityReferenceType) {
        val toBeMapped = Either.ofRight<String, IntegrationRuntimeEntityReferenceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EntityReferenceArgs = EntityReferenceArgs(
        referenceName = referenceName,
        type = type,
    )
}
