@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ExecuteWranglingDataflowActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Execute power query activity.
 * @property compute Compute properties for data flow activity.
 * @property continueOnError Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean)
 * @property dataFlow Data flow reference.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property integrationRuntime The integration runtime reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property queries List of mapping for Power Query mashup query to sink dataset(s).
 * @property runConcurrently Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently. Type: boolean (or Expression with resultType boolean)
 * @property sinks (Deprecated. Please use Queries). List of Power Query activity sinks mapped to a queryName.
 * @property sourceStagingConcurrency Specify number of parallel staging for sources applicable to the sink. Type: integer (or Expression with resultType integer)
 * @property staging Staging info for execute data flow activity.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property traceLevel Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string)
 * @property type Type of activity.
 * Expected value is 'ExecuteWranglingDataflow'.
 * @property userProperties Activity user properties.
 */
public data class ExecuteWranglingDataflowActivityArgs(
    public val compute: Output<ExecuteDataFlowActivityTypePropertiesComputeArgs>? = null,
    public val continueOnError: Output<Any>? = null,
    public val dataFlow: Output<DataFlowReferenceArgs>,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val integrationRuntime: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val queries: Output<List<PowerQuerySinkMappingArgs>>? = null,
    public val runConcurrently: Output<Any>? = null,
    public val sinks: Output<Map<String, PowerQuerySinkArgs>>? = null,
    public val sourceStagingConcurrency: Output<Any>? = null,
    public val staging: Output<DataFlowStagingInfoArgs>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val traceLevel: Output<Any>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ExecuteWranglingDataflowActivityArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.ExecuteWranglingDataflowActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.ExecuteWranglingDataflowActivityArgs.builder()
            .compute(compute?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .continueOnError(continueOnError?.applyValue({ args0 -> args0 }))
            .dataFlow(dataFlow.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .integrationRuntime(
                integrationRuntime?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queries(
                queries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .runConcurrently(runConcurrently?.applyValue({ args0 -> args0 }))
            .sinks(
                sinks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.let({ args0 ->
                                args0.toJava()
                            }),
                        )
                    }).toMap()
                }),
            )
            .sourceStagingConcurrency(sourceStagingConcurrency?.applyValue({ args0 -> args0 }))
            .staging(staging?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .traceLevel(traceLevel?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExecuteWranglingDataflowActivityArgs].
 */
@PulumiTagMarker
public class ExecuteWranglingDataflowActivityArgsBuilder internal constructor() {
    private var compute: Output<ExecuteDataFlowActivityTypePropertiesComputeArgs>? = null

    private var continueOnError: Output<Any>? = null

    private var dataFlow: Output<DataFlowReferenceArgs>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var integrationRuntime: Output<IntegrationRuntimeReferenceArgs>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var queries: Output<List<PowerQuerySinkMappingArgs>>? = null

    private var runConcurrently: Output<Any>? = null

    private var sinks: Output<Map<String, PowerQuerySinkArgs>>? = null

    private var sourceStagingConcurrency: Output<Any>? = null

    private var staging: Output<DataFlowStagingInfoArgs>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var traceLevel: Output<Any>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value Compute properties for data flow activity.
     */
    @JvmName("vmbluadsthsclruc")
    public suspend fun compute(`value`: Output<ExecuteDataFlowActivityTypePropertiesComputeArgs>) {
        this.compute = value
    }

    /**
     * @param value Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean)
     */
    @JvmName("uhxxmocroussukvh")
    public suspend fun continueOnError(`value`: Output<Any>) {
        this.continueOnError = value
    }

    /**
     * @param value Data flow reference.
     */
    @JvmName("uqvfxetetxmluxid")
    public suspend fun dataFlow(`value`: Output<DataFlowReferenceArgs>) {
        this.dataFlow = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("jnxjcskofaupguhv")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("gffpigcmcrnwhnlm")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("qutjvdcsdyfdvqgn")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("uljfgcdqatnyfqew")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("sdscvfknqrgpgmbk")
    public suspend fun integrationRuntime(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.integrationRuntime = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("ikojhnlyugaorjus")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("jevtdtmmtkggfxdu")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("xcwbxnaxvsrmtcqv")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value List of mapping for Power Query mashup query to sink dataset(s).
     */
    @JvmName("dwdxcfgpkjfvxhwv")
    public suspend fun queries(`value`: Output<List<PowerQuerySinkMappingArgs>>) {
        this.queries = value
    }

    @JvmName("hqfnqygegsgawysv")
    public suspend fun queries(vararg values: Output<PowerQuerySinkMappingArgs>) {
        this.queries = Output.all(values.asList())
    }

    /**
     * @param values List of mapping for Power Query mashup query to sink dataset(s).
     */
    @JvmName("uoouqjcpqvmjnari")
    public suspend fun queries(values: List<Output<PowerQuerySinkMappingArgs>>) {
        this.queries = Output.all(values)
    }

    /**
     * @param value Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently. Type: boolean (or Expression with resultType boolean)
     */
    @JvmName("lcdxsybbtrlbvbup")
    public suspend fun runConcurrently(`value`: Output<Any>) {
        this.runConcurrently = value
    }

    /**
     * @param value (Deprecated. Please use Queries). List of Power Query activity sinks mapped to a queryName.
     */
    @JvmName("kieppaiukcuenjca")
    public suspend fun sinks(`value`: Output<Map<String, PowerQuerySinkArgs>>) {
        this.sinks = value
    }

    /**
     * @param value Specify number of parallel staging for sources applicable to the sink. Type: integer (or Expression with resultType integer)
     */
    @JvmName("cnmodgwqeilrsord")
    public suspend fun sourceStagingConcurrency(`value`: Output<Any>) {
        this.sourceStagingConcurrency = value
    }

    /**
     * @param value Staging info for execute data flow activity.
     */
    @JvmName("qduwjnupdobfwpbj")
    public suspend fun staging(`value`: Output<DataFlowStagingInfoArgs>) {
        this.staging = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("rrjioyigepqgdfpa")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string)
     */
    @JvmName("wtjgypgtfoeurqce")
    public suspend fun traceLevel(`value`: Output<Any>) {
        this.traceLevel = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'ExecuteWranglingDataflow'.
     */
    @JvmName("wwacjtgdjmywbvhf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("wvanjcginukhaqmx")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("lyjlhwqdhexasjmc")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("lyhuljhmvhydwscw")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value Compute properties for data flow activity.
     */
    @JvmName("jomdkqpnlqpfwlpw")
    public suspend fun compute(`value`: ExecuteDataFlowActivityTypePropertiesComputeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compute = mapped
    }

    /**
     * @param argument Compute properties for data flow activity.
     */
    @JvmName("cnfokiaooesjtgau")
    public suspend
    fun compute(argument: suspend ExecuteDataFlowActivityTypePropertiesComputeArgsBuilder.() -> Unit) {
        val toBeMapped = ExecuteDataFlowActivityTypePropertiesComputeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.compute = mapped
    }

    /**
     * @param value Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean)
     */
    @JvmName("ktwsdtgdusenbwxt")
    public suspend fun continueOnError(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.continueOnError = mapped
    }

    /**
     * @param value Data flow reference.
     */
    @JvmName("xqcbhqtbutshdkeo")
    public suspend fun dataFlow(`value`: DataFlowReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFlow = mapped
    }

    /**
     * @param argument Data flow reference.
     */
    @JvmName("ypxurxcubnskgtqh")
    public suspend fun dataFlow(argument: suspend DataFlowReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = DataFlowReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataFlow = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("rljawkhbrtbtuyuh")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("unnwwanlcheekdys")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("fltdopxpakrpejjr")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("iqvymhkkjcapaohh")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("pbpffwwatqcmmirb")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("yccahwwsxtonphyd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("cebyunmpufnmfrtp")
    public suspend fun integrationRuntime(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationRuntime = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("gkybdtnkivpldenu")
    public suspend
    fun integrationRuntime(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.integrationRuntime = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("vjvbxjaaueadrwmb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("atqkeokvkhuyoegw")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("xavxrsyhayfcsarw")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("shmukyvxafxudexh")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("cakbbpkyxxkocmmr")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("docmfjcyhemlqgfe")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value List of mapping for Power Query mashup query to sink dataset(s).
     */
    @JvmName("cceklyaavnjpajrd")
    public suspend fun queries(`value`: List<PowerQuerySinkMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queries = mapped
    }

    /**
     * @param argument List of mapping for Power Query mashup query to sink dataset(s).
     */
    @JvmName("bvfqmcqdljdrausm")
    public suspend fun queries(argument: List<suspend PowerQuerySinkMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PowerQuerySinkMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queries = mapped
    }

    /**
     * @param argument List of mapping for Power Query mashup query to sink dataset(s).
     */
    @JvmName("thpjbmeejwxralif")
    public suspend fun queries(vararg argument: suspend PowerQuerySinkMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PowerQuerySinkMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.queries = mapped
    }

    /**
     * @param argument List of mapping for Power Query mashup query to sink dataset(s).
     */
    @JvmName("naeyscpeuglvisxi")
    public suspend fun queries(argument: suspend PowerQuerySinkMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PowerQuerySinkMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.queries = mapped
    }

    /**
     * @param values List of mapping for Power Query mashup query to sink dataset(s).
     */
    @JvmName("higrfcswdmbcodki")
    public suspend fun queries(vararg values: PowerQuerySinkMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.queries = mapped
    }

    /**
     * @param value Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently. Type: boolean (or Expression with resultType boolean)
     */
    @JvmName("flndppcdrtbthmcq")
    public suspend fun runConcurrently(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runConcurrently = mapped
    }

    /**
     * @param value (Deprecated. Please use Queries). List of Power Query activity sinks mapped to a queryName.
     */
    @JvmName("ethgtpepxpwmqggf")
    public suspend fun sinks(`value`: Map<String, PowerQuerySinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param argument (Deprecated. Please use Queries). List of Power Query activity sinks mapped to a queryName.
     */
    @JvmName("xlsfypbtdutkwfhl")
    public suspend fun sinks(
        vararg
        argument: Pair<String, suspend PowerQuerySinkArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                PowerQuerySinkArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.sinks = mapped
    }

    /**
     * @param values (Deprecated. Please use Queries). List of Power Query activity sinks mapped to a queryName.
     */
    @JvmName("llecqqqgvfemtdac")
    public fun sinks(vararg values: Pair<String, PowerQuerySinkArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sinks = mapped
    }

    /**
     * @param value Specify number of parallel staging for sources applicable to the sink. Type: integer (or Expression with resultType integer)
     */
    @JvmName("wrueeympnijobvtj")
    public suspend fun sourceStagingConcurrency(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceStagingConcurrency = mapped
    }

    /**
     * @param value Staging info for execute data flow activity.
     */
    @JvmName("inayhpbqfkjhknkg")
    public suspend fun staging(`value`: DataFlowStagingInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staging = mapped
    }

    /**
     * @param argument Staging info for execute data flow activity.
     */
    @JvmName("ueggmixkmckridhh")
    public suspend fun staging(argument: suspend DataFlowStagingInfoArgsBuilder.() -> Unit) {
        val toBeMapped = DataFlowStagingInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.staging = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("yoelpgiewbaekorq")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("xfohxmuoqkdjwium")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("sxwtcgjdaqmktwto")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string)
     */
    @JvmName("jgsngyxhislwlnnc")
    public suspend fun traceLevel(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.traceLevel = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'ExecuteWranglingDataflow'.
     */
    @JvmName("intcdvpvoqujoouv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("yakjfuwfgyvrpjau")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("kjmybfdubyipaeqm")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("fsgebrghwnuefmcp")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("loskppjfskurxddg")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("fehryrnptyuyjdra")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): ExecuteWranglingDataflowActivityArgs = ExecuteWranglingDataflowActivityArgs(
        compute = compute,
        continueOnError = continueOnError,
        dataFlow = dataFlow ?: throw PulumiNullFieldException("dataFlow"),
        dependsOn = dependsOn,
        description = description,
        integrationRuntime = integrationRuntime,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        policy = policy,
        queries = queries,
        runConcurrently = runConcurrently,
        sinks = sinks,
        sourceStagingConcurrency = sourceStagingConcurrency,
        staging = staging,
        state = state,
        traceLevel = traceLevel,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
