@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.FactoryVSTSConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Factory's VSTS repo information.
 * @property accountName Account name.
 * @property collaborationBranch Collaboration branch.
 * @property disablePublish Disable manual publish operation in ADF studio to favor automated publish.
 * @property lastCommitId Last commit id.
 * @property projectName VSTS project name.
 * @property repositoryName Repository name.
 * @property rootFolder Root folder.
 * @property tenantId VSTS tenant id.
 * @property type Type of repo configuration.
 * Expected value is 'FactoryVSTSConfiguration'.
 */
public data class FactoryVSTSConfigurationArgs(
    public val accountName: Output<String>,
    public val collaborationBranch: Output<String>,
    public val disablePublish: Output<Boolean>? = null,
    public val lastCommitId: Output<String>? = null,
    public val projectName: Output<String>,
    public val repositoryName: Output<String>,
    public val rootFolder: Output<String>,
    public val tenantId: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.FactoryVSTSConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.FactoryVSTSConfigurationArgs =
        com.pulumi.azurenative.datafactory.inputs.FactoryVSTSConfigurationArgs.builder()
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .collaborationBranch(collaborationBranch.applyValue({ args0 -> args0 }))
            .disablePublish(disablePublish?.applyValue({ args0 -> args0 }))
            .lastCommitId(lastCommitId?.applyValue({ args0 -> args0 }))
            .projectName(projectName.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName.applyValue({ args0 -> args0 }))
            .rootFolder(rootFolder.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FactoryVSTSConfigurationArgs].
 */
@PulumiTagMarker
public class FactoryVSTSConfigurationArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var collaborationBranch: Output<String>? = null

    private var disablePublish: Output<Boolean>? = null

    private var lastCommitId: Output<String>? = null

    private var projectName: Output<String>? = null

    private var repositoryName: Output<String>? = null

    private var rootFolder: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Account name.
     */
    @JvmName("rrpibudhwedoecfo")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Collaboration branch.
     */
    @JvmName("lbksuegnoqhiggqk")
    public suspend fun collaborationBranch(`value`: Output<String>) {
        this.collaborationBranch = value
    }

    /**
     * @param value Disable manual publish operation in ADF studio to favor automated publish.
     */
    @JvmName("ruaohibudmdnuwfv")
    public suspend fun disablePublish(`value`: Output<Boolean>) {
        this.disablePublish = value
    }

    /**
     * @param value Last commit id.
     */
    @JvmName("xeulqsgbtpkmbxlc")
    public suspend fun lastCommitId(`value`: Output<String>) {
        this.lastCommitId = value
    }

    /**
     * @param value VSTS project name.
     */
    @JvmName("btfeqiebebiebrxh")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Repository name.
     */
    @JvmName("xyjdltbdnqimhgva")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value Root folder.
     */
    @JvmName("timjwkdrlgdaqvut")
    public suspend fun rootFolder(`value`: Output<String>) {
        this.rootFolder = value
    }

    /**
     * @param value VSTS tenant id.
     */
    @JvmName("bcoljviqnvagglus")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Type of repo configuration.
     * Expected value is 'FactoryVSTSConfiguration'.
     */
    @JvmName("tadcfdlraewulebd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Account name.
     */
    @JvmName("lxlgfawbbmjvcget")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Collaboration branch.
     */
    @JvmName("ilfhsyfmqsjcqflj")
    public suspend fun collaborationBranch(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collaborationBranch = mapped
    }

    /**
     * @param value Disable manual publish operation in ADF studio to favor automated publish.
     */
    @JvmName("gateqvvxijipbxsf")
    public suspend fun disablePublish(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disablePublish = mapped
    }

    /**
     * @param value Last commit id.
     */
    @JvmName("ytlormthrsngwlqa")
    public suspend fun lastCommitId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastCommitId = mapped
    }

    /**
     * @param value VSTS project name.
     */
    @JvmName("mvyppoolcddsdrpi")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Repository name.
     */
    @JvmName("bfxbjyffaoucowee")
    public suspend fun repositoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value Root folder.
     */
    @JvmName("awonsbfbbetkpuin")
    public suspend fun rootFolder(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rootFolder = mapped
    }

    /**
     * @param value VSTS tenant id.
     */
    @JvmName("dlgrmejbqtpucklw")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value Type of repo configuration.
     * Expected value is 'FactoryVSTSConfiguration'.
     */
    @JvmName("jqsvvgmkboagnhiv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FactoryVSTSConfigurationArgs = FactoryVSTSConfigurationArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        collaborationBranch = collaborationBranch ?: throw PulumiNullFieldException("collaborationBranch"),
        disablePublish = disablePublish,
        lastCommitId = lastCommitId,
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        repositoryName = repositoryName ?: throw PulumiNullFieldException("repositoryName"),
        rootFolder = rootFolder ?: throw PulumiNullFieldException("rootFolder"),
        tenantId = tenantId,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
