@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.FailActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * This activity will fail within its own scope and output a custom error message and error code. The error message and code can provided either as a string literal or as an expression that can be evaluated to a string at runtime. The activity scope can be the whole pipeline or a control activity (e.g. foreach, switch, until), if the fail activity is contained in it.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property errorCode The error code that categorizes the error type of the Fail activity. It can be dynamic content that's evaluated to a non empty/blank string at runtime. Type: string (or Expression with resultType string).
 * @property message The error message that surfaced in the Fail activity. It can be dynamic content that's evaluated to a non empty/blank string at runtime. Type: string (or Expression with resultType string).
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'Fail'.
 * @property userProperties Activity user properties.
 */
public data class FailActivityArgs(
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val errorCode: Output<Any>,
    public val message: Output<Any>,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.FailActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.FailActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.FailActivityArgs.builder()
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .errorCode(errorCode.applyValue({ args0 -> args0 }))
            .message(message.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FailActivityArgs].
 */
@PulumiTagMarker
public class FailActivityArgsBuilder internal constructor() {
    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var errorCode: Output<Any>? = null

    private var message: Output<Any>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("lqhvdkgobxnbqkul")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("ydniwevpmtjarpch")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("mqoywkgmpntuybye")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("wyiqtbmbiqorjijc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The error code that categorizes the error type of the Fail activity. It can be dynamic content that's evaluated to a non empty/blank string at runtime. Type: string (or Expression with resultType string).
     */
    @JvmName("pbogargeoxbieomf")
    public suspend fun errorCode(`value`: Output<Any>) {
        this.errorCode = value
    }

    /**
     * @param value The error message that surfaced in the Fail activity. It can be dynamic content that's evaluated to a non empty/blank string at runtime. Type: string (or Expression with resultType string).
     */
    @JvmName("uemwreyvywcuribm")
    public suspend fun message(`value`: Output<Any>) {
        this.message = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("eqrpdyqfyalouqdl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("makerfgxcfgmmdyo")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("njdvmdgjtehnwhlx")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'Fail'.
     */
    @JvmName("rufltlqjcqqdrehc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("amjkdlvekidbaiwr")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("mklicshdhaskytwv")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("jufikpjeittdkayy")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("qhptqhcvcydhankq")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("mattymowyufcqqhv")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("ffflkvnjkgyusgbw")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("lwyluythekvyulnf")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("tskakpelvitqduky")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("anlgerbpqwkhvnta")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The error code that categorizes the error type of the Fail activity. It can be dynamic content that's evaluated to a non empty/blank string at runtime. Type: string (or Expression with resultType string).
     */
    @JvmName("ewprwrugclmiwjcm")
    public suspend fun errorCode(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errorCode = mapped
    }

    /**
     * @param value The error message that surfaced in the Fail activity. It can be dynamic content that's evaluated to a non empty/blank string at runtime. Type: string (or Expression with resultType string).
     */
    @JvmName("oqbpchurpyhrpxdu")
    public suspend fun message(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("qotuaxjfjtaenten")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("thwadxchllqvpmpp")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("elsemuejjdbyyuvm")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("myebujrewvygnsin")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("rlcshelqheksrsub")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("cafpuwhbfdshyyfq")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ostypblbfgfebmsa")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'Fail'.
     */
    @JvmName("sdndojayctsjenqh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("ytdrdgyvvdueqmow")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("kjbipaoqhowkgxrq")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("vntscbxouaxicbgh")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("jpsxkfkkaofumece")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("nfnehshngccrijys")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): FailActivityArgs = FailActivityArgs(
        dependsOn = dependsOn,
        description = description,
        errorCode = errorCode ?: throw PulumiNullFieldException("errorCode"),
        message = message ?: throw PulumiNullFieldException("message"),
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
