@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ForEachActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * This activity is used for iterating over a collection and execute given activities.
 * @property activities List of activities to execute .
 * @property batchCount Batch count to be used for controlling the number of parallel execution (when isSequential is set to false).
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property isSequential Should the loop be executed in sequence or in parallel (max 50)
 * @property items Collection to iterate.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'ForEach'.
 * @property userProperties Activity user properties.
 */
public data class ForEachActivityArgs(
    public val activities: Output<List<Any>>,
    public val batchCount: Output<Int>? = null,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val isSequential: Output<Boolean>? = null,
    public val items: Output<ExpressionArgs>,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ForEachActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ForEachActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.ForEachActivityArgs.builder()
            .activities(activities.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .batchCount(batchCount?.applyValue({ args0 -> args0 }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .isSequential(isSequential?.applyValue({ args0 -> args0 }))
            .items(items.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ForEachActivityArgs].
 */
@PulumiTagMarker
public class ForEachActivityArgsBuilder internal constructor() {
    private var activities: Output<List<Any>>? = null

    private var batchCount: Output<Int>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var isSequential: Output<Boolean>? = null

    private var items: Output<ExpressionArgs>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value List of activities to execute .
     */
    @JvmName("noellebwpkduujeo")
    public suspend fun activities(`value`: Output<List<Any>>) {
        this.activities = value
    }

    @JvmName("jewcpdkhcftnxvat")
    public suspend fun activities(vararg values: Output<Any>) {
        this.activities = Output.all(values.asList())
    }

    /**
     * @param values List of activities to execute .
     */
    @JvmName("rffxesjjmgwpsmbj")
    public suspend fun activities(values: List<Output<Any>>) {
        this.activities = Output.all(values)
    }

    /**
     * @param value Batch count to be used for controlling the number of parallel execution (when isSequential is set to false).
     */
    @JvmName("yjvuguoftlxglcww")
    public suspend fun batchCount(`value`: Output<Int>) {
        this.batchCount = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("gyuxekgkuwslnljv")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("vgtncadxlnnltecw")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("vourkkxjhjuwhdwu")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("aiuvaldsysmutwsq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Should the loop be executed in sequence or in parallel (max 50)
     */
    @JvmName("iouthsqqgxmnsxmh")
    public suspend fun isSequential(`value`: Output<Boolean>) {
        this.isSequential = value
    }

    /**
     * @param value Collection to iterate.
     */
    @JvmName("euevcyxsvgosijgl")
    public suspend fun items(`value`: Output<ExpressionArgs>) {
        this.items = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("kehqogjhajgrylos")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("llymrqpdrajsgtgd")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("wrcuutclgcvnduda")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'ForEach'.
     */
    @JvmName("revksnwfotyxrwtj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("eguqxbsyskkgcbpa")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("qthqgaqunaxmstrm")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("mfpejratfbixpcri")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value List of activities to execute .
     */
    @JvmName("xyntrstlouvbufnj")
    public suspend fun activities(`value`: List<Any>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activities = mapped
    }

    /**
     * @param values List of activities to execute .
     */
    @JvmName("badoammiylsoiuml")
    public suspend fun activities(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activities = mapped
    }

    /**
     * @param value Batch count to be used for controlling the number of parallel execution (when isSequential is set to false).
     */
    @JvmName("dqouejcwiohfspjs")
    public suspend fun batchCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchCount = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("mucfperaekmfvevp")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("wgxbocumqwiyvsue")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("ywpdiwtmlcnemeyx")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("abblomwdgtuwdqyd")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("vqiwieiaqxgqinvu")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("fwhywkjbcgpkaysx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Should the loop be executed in sequence or in parallel (max 50)
     */
    @JvmName("qewgeyiinkjtqrbk")
    public suspend fun isSequential(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSequential = mapped
    }

    /**
     * @param value Collection to iterate.
     */
    @JvmName("swjghcgfxxmolcqd")
    public suspend fun items(`value`: ExpressionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.items = mapped
    }

    /**
     * @param argument Collection to iterate.
     */
    @JvmName("ophojuitupgtirbl")
    public suspend fun items(argument: suspend ExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.items = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("rqcmkotelfeqmihp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("yxiwtoljpkdhwpsq")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("yktvmcpiqeapgxfb")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("nfpnpdcrplttwocc")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("nqfanrxydwfsemce")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("xugavpqlvahyvswc")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("joncfyqbmnadfrny")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'ForEach'.
     */
    @JvmName("kqwuqikmwvdlthkp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("cxuinqksgurpulxm")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("tiwxjdslxruogjdv")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("smocxkiagnnydmef")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("yvxmsrlyddbenecw")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("orkgsfanrrbfffmd")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): ForEachActivityArgs = ForEachActivityArgs(
        activities = activities ?: throw PulumiNullFieldException("activities"),
        batchCount = batchCount,
        dependsOn = dependsOn,
        description = description,
        isSequential = isSequential,
        items = items ?: throw PulumiNullFieldException("items"),
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
