@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetChangeDataCapturePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property changeDataCaptureName The change data capture name.
 * @property factoryName The factory name.
 * @property resourceGroupName The resource group name.
 */
public data class GetChangeDataCapturePlainArgs(
    public val changeDataCaptureName: String,
    public val factoryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetChangeDataCapturePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GetChangeDataCapturePlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetChangeDataCapturePlainArgs.builder()
            .changeDataCaptureName(changeDataCaptureName.let({ args0 -> args0 }))
            .factoryName(factoryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetChangeDataCapturePlainArgs].
 */
@PulumiTagMarker
public class GetChangeDataCapturePlainArgsBuilder internal constructor() {
    private var changeDataCaptureName: String? = null

    private var factoryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The change data capture name.
     */
    @JvmName("bdbipxyaiscsclot")
    public suspend fun changeDataCaptureName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.changeDataCaptureName = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("klmamqcpqugivkke")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qocsfuaiwvxuxulw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetChangeDataCapturePlainArgs = GetChangeDataCapturePlainArgs(
        changeDataCaptureName = changeDataCaptureName ?: throw
            PulumiNullFieldException("changeDataCaptureName"),
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
