@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetDatasetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property datasetName The dataset name.
 * @property factoryName The factory name.
 * @property resourceGroupName The resource group name.
 */
public data class GetDatasetPlainArgs(
    public val datasetName: String,
    public val factoryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetDatasetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GetDatasetPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetDatasetPlainArgs.builder()
            .datasetName(datasetName.let({ args0 -> args0 }))
            .factoryName(factoryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatasetPlainArgs].
 */
@PulumiTagMarker
public class GetDatasetPlainArgsBuilder internal constructor() {
    private var datasetName: String? = null

    private var factoryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The dataset name.
     */
    @JvmName("wtqnissvlhnlojac")
    public suspend fun datasetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.datasetName = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("cevlxjdumogdlvhp")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qyfxdouxofmjggsa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDatasetPlainArgs = GetDatasetPlainArgs(
        datasetName = datasetName ?: throw PulumiNullFieldException("datasetName"),
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
