@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GitHubClientSecret.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Client secret information for factory's bring your own app repository configuration.
 * @property byoaSecretAkvUrl Bring your own app client secret AKV URL.
 * @property byoaSecretName Bring your own app client secret name in AKV.
 */
public data class GitHubClientSecret(
    public val byoaSecretAkvUrl: String? = null,
    public val byoaSecretName: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GitHubClientSecret> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GitHubClientSecret =
        com.pulumi.azurenative.datafactory.inputs.GitHubClientSecret.builder()
            .byoaSecretAkvUrl(byoaSecretAkvUrl?.let({ args0 -> args0 }))
            .byoaSecretName(byoaSecretName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GitHubClientSecret].
 */
@PulumiTagMarker
public class GitHubClientSecretBuilder internal constructor() {
    private var byoaSecretAkvUrl: String? = null

    private var byoaSecretName: String? = null

    /**
     * @param value Bring your own app client secret AKV URL.
     */
    @JvmName("uxwvkwdrnqiegqqt")
    public suspend fun byoaSecretAkvUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.byoaSecretAkvUrl = mapped
    }

    /**
     * @param value Bring your own app client secret name in AKV.
     */
    @JvmName("gxaoxqxjacycsmkj")
    public suspend fun byoaSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.byoaSecretName = mapped
    }

    internal fun build(): GitHubClientSecret = GitHubClientSecret(
        byoaSecretAkvUrl = byoaSecretAkvUrl,
        byoaSecretName = byoaSecretName,
    )
}
